from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkRenderingCore

class vtkOpenGLAvatar(vtkmodules.vtkRenderingCore.vtkAvatar):
    bounds:'getset_descriptor'
    label:'getset_descriptor'
    label_text_property:'getset_descriptor'
    left_show_ray:'getset_descriptor'
    ray_length:'getset_descriptor'
    right_show_ray:'getset_descriptor'
    show_hands_only:'getset_descriptor'
    use_left_hand:'getset_descriptor'
    use_right_hand:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetLabel(self) -> str: ...
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOpenGLAvatar': ...
    def RenderOpaqueGeometry(self, vp:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, vp:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOpenGLAvatar': ...
    def SetLabel(self, label:str) -> None: ...
    def SetLeftShowRay(self, v:bool) -> None: ...
    def SetRayLength(self, length:float) -> None: ...
    def SetRightShowRay(self, v:bool) -> None: ...
    def SetShowHandsOnly(self, val:bool) -> None: ...
    def SetUseLeftHand(self, val:bool) -> None: ...
    def SetUseRightHand(self, val:bool) -> None: ...

class vtkVRRay(vtkmodules.vtkCommonCore.vtkObject):
    color:'getset_descriptor'
    length:'getset_descriptor'
    show:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Build(self, win:'vtkOpenGLRenderWindow') -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShow(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRRay': ...
    def ReleaseGraphicsResources(self, win:'vtkRenderWindow') -> None: ...
    def Render(self, win:'vtkOpenGLRenderWindow', poseMatrix:'vtkMatrix4x4') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRRay': ...
    @overload
    def SetColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetColor(self, _arg:Sequence[float]) -> None: ...
    def SetLength(self, _arg:float) -> None: ...
    def SetShow(self, _arg:bool) -> None: ...

