from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkInteractionWidgets
import vtkmodules.vtkRenderingCore
import vtkmodules.vtkRenderingOpenGL2

class vtkVRCamera(vtkmodules.vtkRenderingOpenGL2.vtkOpenGLCamera):
    track_hmd:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTrackHMD(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRCamera': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRCamera': ...
    def SetCameraFromDeviceToWorldMatrix(self, mat:'vtkMatrix4x4', distance:float) -> None: ...
    def SetCameraFromWorldToDeviceMatrix(self, mat:'vtkMatrix4x4', distance:float) -> None: ...
    def SetTrackHMD(self, _arg:bool) -> None: ...

class vtkVRControlsHelper(vtkmodules.vtkRenderingCore.vtkProp):
    class ButtonSides(int): ...
    class DrawSides(int): ...
    Back:'ButtonSides'
    Front:'ButtonSides'
    Left:'DrawSides'
    Right:'DrawSides'
    device:'getset_descriptor'
    enabled:'getset_descriptor'
    renderer:'getset_descriptor'
    text:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def EnabledOff(self) -> None: ...
    def EnabledOn(self) -> None: ...
    def GetEnabled(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRControlsHelper': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRControlsHelper': ...
    def SetDevice(self, val:'vtkEventDataDevice') -> None: ...
    def SetEnabled(self, enabled:bool) -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...
    def SetText(self, str:str) -> None: ...
    def SetTooltipInfo(self, s:str, buttonSide:int, drawSide:int, txt:str) -> None: ...
    def UpdateRepresentation(self) -> None: ...

class vtkVRFollower(vtkmodules.vtkRenderingCore.vtkFollower):
    def __init__(self, **properties:Any) -> None: ...
    def ComputeMatrix(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRFollower': ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRFollower': ...

class vtkVRHMDCamera(vtkVRCamera):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRHMDCamera': ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRHMDCamera': ...

class vtkVRHardwarePicker(vtkmodules.vtkRenderingCore.vtkPropPicker):
    selection:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelection(self) -> 'vtkSelection': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRHardwarePicker': ...
    def PickProp(self, selectionPt:MutableSequence[float], eventWorldOrientation:MutableSequence[float], renderer:'vtkRenderer', pickfrom:'vtkPropCollection', actorPassOnly:bool) -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRHardwarePicker': ...

class vtkVRInteractorStyle(vtkmodules.vtkRenderingCore.vtkInteractorStyle3D):
    class MovementStyle(int): ...
    FLY_STYLE:'MovementStyle'
    GROUNDED_STYLE:'MovementStyle'
    draw_controls:'getset_descriptor'
    grab_with_ray:'getset_descriptor'
    hover_pick:'getset_descriptor'
    interactor:'getset_descriptor'
    menu:'getset_descriptor'
    style:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddTooltipForInput(self, device:'vtkEventDataDevice', input:'vtkEventDataDeviceInput', text:str=...) -> None: ...
    def Clip(self, __a:'vtkEventDataDevice3D') -> None: ...
    def Elevation3D(self, __a:'vtkEventDataDevice3D') -> None: ...
    def EndClip(self, __a:'vtkEventDataDevice3D') -> None: ...
    def EndLoadCamPose(self, __a:'vtkEventDataDevice3D') -> None: ...
    def EndMovement3D(self, __a:'vtkEventDataDevice3D') -> None: ...
    def EndPick(self, __a:'vtkEventDataDevice3D') -> None: ...
    def EndPositionProp(self, __a:'vtkEventDataDevice3D') -> None: ...
    def GetGrabWithRay(self) -> bool: ...
    def GetHoverPick(self) -> bool: ...
    def GetInteractionState(self, device:'vtkEventDataDevice') -> int: ...
    def GetMappedAction(self, eid:vtkCommand.EventIds, action:'vtkEventDataAction'=...) -> int: ...
    def GetMenu(self) -> 'vtkVRMenuWidget': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStyle(self) -> 'MovementStyle': ...
    def GrabWithRayOff(self) -> None: ...
    def GrabWithRayOn(self) -> None: ...
    def GroundMovement3D(self, __a:'vtkEventDataDevice3D') -> None: ...
    def HideBillboard(self) -> None: ...
    def HidePickActor(self) -> None: ...
    def HideRay(self, controller:'vtkEventDataDevice') -> None: ...
    def HoverPickOff(self) -> None: ...
    def HoverPickOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LoadNextCameraPose(self) -> None: ...
    def MakeControlsHelper(self) -> 'vtkVRControlsHelper': ...
    @overload
    def MapInputToAction(self, eid:vtkCommand.EventIds, state:int) -> None: ...
    @overload
    def MapInputToAction(self, eid:vtkCommand.EventIds, action:'vtkEventDataAction', state:int) -> None: ...
    def NewInstance(self) -> 'vtkVRInteractorStyle': ...
    def OnElevation3D(self, edata:'vtkEventData') -> None: ...
    def OnMenu3D(self, edata:'vtkEventData') -> None: ...
    def OnMove3D(self, edata:'vtkEventData') -> None: ...
    def OnNextPose3D(self, edata:'vtkEventData') -> None: ...
    def OnPan(self) -> None: ...
    def OnPinch(self) -> None: ...
    def OnRotate(self) -> None: ...
    def OnSelect3D(self, edata:'vtkEventData') -> None: ...
    def OnViewerMovement3D(self, edata:'vtkEventData') -> None: ...
    def PositionProp(self, __a:'vtkEventData', lwpos:MutableSequence[float]=..., lwori:MutableSequence[float]=...) -> None: ...
    def ProbeData(self, controller:'vtkEventDataDevice') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRInteractorStyle': ...
    def SetDrawControls(self, __a:bool) -> None: ...
    def SetGrabWithRay(self, _arg:bool) -> None: ...
    def SetHoverPick(self, _arg:bool) -> None: ...
    def SetInteractionState(self, device:'vtkEventDataDevice', state:int) -> None: ...
    def SetInteractor(self, iren:'vtkRenderWindowInteractor') -> None: ...
    def SetStyle(self, _arg:'MovementStyle') -> None: ...
    def SetupActions(self, iren:'vtkRenderWindowInteractor') -> None: ...
    def ShowBillboard(self, text:str) -> None: ...
    def ShowPickCell(self, cell:'vtkCell', __b:'vtkProp3D') -> None: ...
    def ShowPickSphere(self, pos:MutableSequence[float], radius:float, __c:'vtkProp3D') -> None: ...
    def ShowRay(self, controller:'vtkEventDataDevice') -> None: ...
    def StartClip(self, __a:'vtkEventDataDevice3D') -> None: ...
    def StartLoadCamPose(self, __a:'vtkEventDataDevice3D') -> None: ...
    def StartMovement3D(self, interactionState:int, __b:'vtkEventDataDevice3D') -> None: ...
    def StartPick(self, __a:'vtkEventDataDevice3D') -> None: ...
    def StartPositionProp(self, __a:'vtkEventDataDevice3D') -> None: ...
    def Teleportation3D(self, edd:'vtkEventDataDevice3D') -> None: ...
    def ToggleDrawControls(self) -> None: ...

class vtkVRMenuRepresentation(vtkmodules.vtkInteractionWidgets.vtkWidgetRepresentation):
    current_option:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def ComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def EndComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def GetCurrentOption(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRMenuRepresentation': ...
    def PushFrontMenuItem(self, name:str, text:str, cmd:'vtkCommand') -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveAllMenuItems(self) -> None: ...
    def RemoveMenuItem(self, name:str) -> None: ...
    def RenameMenuItem(self, name:str, text:str) -> None: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRMenuRepresentation': ...
    def StartComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...

class vtkVRMenuWidget(vtkmodules.vtkInteractionWidgets.vtkAbstractWidget):
    class WidgetStateType(int): ...
    Active:'WidgetStateType'
    Start:'WidgetStateType'
    representation:'getset_descriptor'
    widget_state:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWidgetState(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRMenuWidget': ...
    def PushFrontMenuItem(self, name:str, text:str, cmd:'vtkCommand') -> None: ...
    def RemoveAllMenuItems(self) -> None: ...
    def RemoveMenuItem(self, name:str) -> None: ...
    def RenameMenuItem(self, name:str, text:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRMenuWidget': ...
    def SetRepresentation(self, rep:'vtkVRMenuRepresentation') -> None: ...
    def Show(self, ed:'vtkEventData') -> None: ...
    def ShowSubMenu(self, __a:'vtkVRMenuWidget') -> None: ...

class vtkVRModel(vtkmodules.vtkCommonCore.vtkObject):
    name:'getset_descriptor'
    ray:'getset_descriptor'
    ray_color:'getset_descriptor'
    ray_length:'getset_descriptor'
    show_ray:'getset_descriptor'
    visibility:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def Build(self, win:'vtkOpenGLRenderWindow') -> bool: ...
    def GetName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRay(self) -> 'vtkVRRay': ...
    def GetVisibility(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRModel': ...
    def ReleaseGraphicsResources(self, win:'vtkWindow') -> None: ...
    def Render(self, win:'vtkOpenGLRenderWindow', poseInTrackingCoordinates:'vtkMatrix4x4') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRModel': ...
    def SetName(self, modelName:str) -> None: ...
    def SetRayColor(self, r:float, g:float, b:float) -> None: ...
    def SetRayLength(self, length:float) -> None: ...
    def SetShowRay(self, v:bool) -> None: ...
    def SetVisibility(self, v:bool) -> None: ...

class vtkVRPanelRepresentation(vtkmodules.vtkInteractionWidgets.vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    Moving:'InteractionStateType'
    Outside:'InteractionStateType'
    allow_adjustment:'getset_descriptor'
    text:'getset_descriptor'
    text_actor:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AllowAdjustmentOff(self) -> None: ...
    def AllowAdjustmentOn(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def ComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def ComputeComplexInteractionState(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer, modify:int=0) -> int: ...
    def EndComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...
    def GetAllowAdjustment(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextActor(self) -> 'vtkTextActor3D': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRPanelRepresentation': ...
    def PlaceWidget(self, bounds:MutableSequence[float]) -> None: ...
    def PlaceWidgetExtended(self, bounds:Sequence[float], normal:Sequence[float] , upvec:Sequence[float], scale:float) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRPanelRepresentation': ...
    def SetAllowAdjustment(self, _arg:bool) -> None: ...
    def SetCoordinateSystemToHMD(self) -> None: ...
    def SetCoordinateSystemToLeftController(self) -> None: ...
    def SetCoordinateSystemToRightController(self) -> None: ...
    def SetCoordinateSystemToWorld(self) -> None: ...
    def SetText(self, str:str) -> None: ...
    def StartComplexInteraction(self, iren:'vtkRenderWindowInteractor', widget:'vtkAbstractWidget', event:int, calldata:Pointer) -> None: ...

class vtkVRPanelWidget(vtkmodules.vtkInteractionWidgets.vtkAbstractWidget):
    representation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRPanelWidget': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRPanelWidget': ...
    def SetRepresentation(self, rep:'vtkVRPanelRepresentation') -> None: ...

class vtkVRRenderWindow(vtkmodules.vtkRenderingOpenGL2.vtkOpenGLRenderWindow):
    LeftEye:int
    RightEye:int
    base_station_visibility:'getset_descriptor'
    event_pending:'getset_descriptor'
    generic_context:'getset_descriptor'
    generic_display_id:'getset_descriptor'
    generic_drawable:'getset_descriptor'
    generic_parent_id:'getset_descriptor'
    generic_window_id:'getset_descriptor'
    helper_window:'getset_descriptor'
    screen_size:'getset_descriptor'
    size:'getset_descriptor'
    state:'getset_descriptor'
    track_hmd:'getset_descriptor'
    vr_initialized:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddRenderer(self, __a:'vtkRenderer') -> None: ...
    def BaseStationVisibilityOff(self) -> None: ...
    def BaseStationVisibilityOn(self) -> None: ...
    def GetBaseStationVisibility(self) -> bool: ...
    def GetDeviceToPhysicalMatrixForDevice(self, idx:'vtkEventDataDevice') -> 'vtkMatrix4x4': ...
    def GetDeviceToWorldMatrixForDevice(self, device:'vtkEventDataDevice', deviceToWorldMatrix:'vtkMatrix4x4') -> bool: ...
    def GetEventPending(self) -> int: ...
    def GetGenericContext(self) -> Pointer: ...
    def GetGenericDisplayId(self) -> Pointer: ...
    def GetGenericDrawable(self) -> Pointer: ...
    def GetGenericParentId(self) -> Pointer: ...
    def GetGenericWindowId(self) -> Pointer: ...
    def GetHelperWindow(self) -> 'vtkOpenGLRenderWindow': ...
    def GetModelForDevice(self, idx:'vtkEventDataDevice') -> 'vtkVRModel': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderBufferSize(self, width:int, height:int) -> None: ...
    def GetScreenSize(self) -> Tuple[int, int]: ...
    def GetState(self) -> 'vtkOpenGLState': ...
    def GetTrackHMD(self) -> bool: ...
    def GetVRInitialized(self) -> bool: ...
    def InitializeViewFromCamera(self, cam:'vtkCamera') -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsCurrent(self) -> bool: ...
    def IsDirect(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def MakeRenderWindowInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def NewInstance(self) -> 'vtkVRRenderWindow': ...
    def ReleaseCurrent(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def Render(self) -> None: ...
    def RenderModels(self) -> None: ...
    def ReportCapabilities(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRRenderWindow': ...
    def SetBaseStationVisibility(self, _arg:bool) -> None: ...
    def SetHelperWindow(self, val:'vtkOpenGLRenderWindow') -> None: ...
    @overload
    def SetSize(self, width:int, height:int) -> None: ...
    @overload
    def SetSize(self, a:MutableSequence[int]) -> None: ...
    def SetTrackHMD(self, __a:bool) -> None: ...
    def SupportsOpenGL(self) -> int: ...
    def UpdateHMDMatrixPose(self) -> None: ...

class vtkVRRenderWindowInteractor(vtkmodules.vtkRenderingCore.vtkRenderWindowInteractor3D):
    action_manifest_directory:'getset_descriptor'
    action_manifest_file_name:'getset_descriptor'
    action_set_name:'getset_descriptor'
    physical_scale:'getset_descriptor'
    physical_view_direction:'getset_descriptor'
    physical_view_up:'getset_descriptor'
    pointer_device:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddAction(self, path:str, __b:vtkCommand.EventIds, isAnalog:bool) -> None: ...
    def ConvertPoseToWorldCoordinates(self, poseInTrackingCoordinates:'vtkMatrix4x4', pos:MutableSequence[float], wxyz:MutableSequence[float], ppos:MutableSequence[float], wdir:MutableSequence[float]) -> None: ...
    def DoOneEvent(self, renWin:'vtkVRRenderWindow', ren:'vtkRenderer') -> None: ...
    def ExitCallback(self) -> None: ...
    def GetActionManifestDirectory(self) -> str: ...
    def GetActionManifestFileName(self) -> str: ...
    def GetActionSetName(self) -> str: ...
    def GetDeviceInputDownCount(self, device:'vtkEventDataDevice') -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhysicalScale(self) -> float: ...
    def GetPhysicalTranslation(self, __a:'vtkCamera') -> Pointer: ...
    def GetPhysicalViewDirection(self) -> Pointer: ...
    def GetPhysicalViewUp(self) -> Pointer: ...
    def GetPointerDevice(self) -> 'vtkEventDataDevice': ...
    def HandleComplexGestureEvents(self, ed:'vtkEventData') -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVRRenderWindowInteractor': ...
    def ProcessEvents(self) -> None: ...
    def RecognizeComplexGesture(self, edata:'vtkEventDataDevice3D') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRRenderWindowInteractor': ...
    def SetActionManifestDirectory(self, _arg:str) -> None: ...
    def SetActionManifestFileName(self, _arg:str) -> None: ...
    def SetActionSetName(self, _arg:str) -> None: ...
    @staticmethod
    def SetClassExitMethod(f:Callback) -> None: ...
    def SetDeviceInputDownCount(self, device:'vtkEventDataDevice', count:int) -> None: ...
    def SetPhysicalScale(self, __a:float) -> None: ...
    def SetPhysicalTranslation(self, __a:'vtkCamera', __b:float, __c:float, __d:float) -> None: ...
    def SetPhysicalViewDirection(self, __a:float, __b:float, __c:float) -> None: ...
    def SetPhysicalViewUp(self, __a:float, __b:float, __c:float) -> None: ...

class vtkVRRenderer(vtkmodules.vtkRenderingOpenGL2.vtkOpenGLRenderer):
    show_floor:'getset_descriptor'
    show_left_marker:'getset_descriptor'
    show_right_marker:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def DeviceRender(self) -> None: ...
    def GetFloorTransform(self, transform:'vtkTransform') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShowFloor(self) -> bool: ...
    def GetShowLeftMarker(self) -> bool: ...
    def GetShowRightMarker(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCamera(self) -> 'vtkCamera': ...
    def NewInstance(self) -> 'vtkVRRenderer': ...
    @overload
    def ResetCamera(self, bounds:Sequence[float]) -> None: ...
    @overload
    def ResetCamera(self) -> None: ...
    @overload
    def ResetCamera(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def ResetCameraClippingRange(self) -> None: ...
    @overload
    def ResetCameraClippingRange(self, bounds:Sequence[float]) -> None: ...
    @overload
    def ResetCameraClippingRange(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVRRenderer': ...
    def SetShowFloor(self, value:bool) -> None: ...
    def SetShowLeftMarker(self, value:bool) -> None: ...
    def SetShowRightMarker(self, value:bool) -> None: ...

