from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkRenderingCore

VTK_IV_COLUMN:int
VTK_IV_ROW:int
VTK_ORIENT_HORIZONTAL:int
VTK_ORIENT_VERTICAL:int
VTK_PLOT_FIELD_DATA:int
VTK_PLOT_NORMALS:int
VTK_PLOT_SCALARS:int
VTK_PLOT_TCOORDS:int
VTK_PLOT_TENSORS:int
VTK_PLOT_VECTORS:int
VTK_XYPLOT_ARC_LENGTH:int
VTK_XYPLOT_COLUMN:int
VTK_XYPLOT_INDEX:int
VTK_XYPLOT_NORMALIZED_ARC_LENGTH:int
VTK_XYPLOT_ROW:int
VTK_XYPLOT_VALUE:int
VTK_XYPLOT_Y_AXIS_HCENTER:int
VTK_XYPLOT_Y_AXIS_TOP:int
VTK_XYPLOT_Y_AXIS_VCENTER:int

class vtkAnnotatedCubeActor(vtkmodules.vtkRenderingCore.vtkProp3D):
    assembly:'getset_descriptor'
    bounds:'getset_descriptor'
    cube_property:'getset_descriptor'
    cube_visibility:'getset_descriptor'
    face_text_scale:'getset_descriptor'
    face_text_visibility:'getset_descriptor'
    m_time:'getset_descriptor'
    text_edges_property:'getset_descriptor'
    text_edges_visibility:'getset_descriptor'
    x_face_text_rotation:'getset_descriptor'
    x_minus_face_property:'getset_descriptor'
    x_minus_face_text:'getset_descriptor'
    x_plus_face_property:'getset_descriptor'
    x_plus_face_text:'getset_descriptor'
    y_face_text_rotation:'getset_descriptor'
    y_minus_face_property:'getset_descriptor'
    y_minus_face_text:'getset_descriptor'
    y_plus_face_property:'getset_descriptor'
    y_plus_face_text:'getset_descriptor'
    z_face_text_rotation:'getset_descriptor'
    z_minus_face_property:'getset_descriptor'
    z_minus_face_text:'getset_descriptor'
    z_plus_face_property:'getset_descriptor'
    z_plus_face_text:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetAssembly(self) -> 'vtkAssembly': ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetCubeProperty(self) -> 'vtkProperty': ...
    def GetCubeVisibility(self) -> int: ...
    def GetFaceTextScale(self) -> float: ...
    def GetFaceTextVisibility(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextEdgesProperty(self) -> 'vtkProperty': ...
    def GetTextEdgesVisibility(self) -> int: ...
    def GetXFaceTextRotation(self) -> float: ...
    def GetXMinusFaceProperty(self) -> 'vtkProperty': ...
    def GetXMinusFaceText(self) -> str: ...
    def GetXPlusFaceProperty(self) -> 'vtkProperty': ...
    def GetXPlusFaceText(self) -> str: ...
    def GetYFaceTextRotation(self) -> float: ...
    def GetYMinusFaceProperty(self) -> 'vtkProperty': ...
    def GetYMinusFaceText(self) -> str: ...
    def GetYPlusFaceProperty(self) -> 'vtkProperty': ...
    def GetYPlusFaceText(self) -> str: ...
    def GetZFaceTextRotation(self) -> float: ...
    def GetZMinusFaceProperty(self) -> 'vtkProperty': ...
    def GetZMinusFaceText(self) -> str: ...
    def GetZPlusFaceProperty(self) -> 'vtkProperty': ...
    def GetZPlusFaceText(self) -> str: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAnnotatedCubeActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAnnotatedCubeActor': ...
    def SetCubeVisibility(self, __a:int) -> None: ...
    def SetFaceTextScale(self, __a:float) -> None: ...
    def SetFaceTextVisibility(self, __a:int) -> None: ...
    def SetTextEdgesVisibility(self, __a:int) -> None: ...
    def SetXFaceTextRotation(self, _arg:float) -> None: ...
    def SetXMinusFaceText(self, _arg:str) -> None: ...
    def SetXPlusFaceText(self, _arg:str) -> None: ...
    def SetYFaceTextRotation(self, _arg:float) -> None: ...
    def SetYMinusFaceText(self, _arg:str) -> None: ...
    def SetYPlusFaceText(self, _arg:str) -> None: ...
    def SetZFaceTextRotation(self, _arg:float) -> None: ...
    def SetZMinusFaceText(self, _arg:str) -> None: ...
    def SetZPlusFaceText(self, _arg:str) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkArcPlotter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    camera:'getset_descriptor'
    default_normal:'getset_descriptor'
    field_data_array:'getset_descriptor'
    height:'getset_descriptor'
    m_time:'getset_descriptor'
    offset:'getset_descriptor'
    plot_component:'getset_descriptor'
    plot_mode:'getset_descriptor'
    radius:'getset_descriptor'
    use_default_normal:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetDefaultNormal(self) -> Tuple[float, float, float]: ...
    def GetFieldDataArray(self) -> int: ...
    def GetFieldDataArrayMaxValue(self) -> int: ...
    def GetFieldDataArrayMinValue(self) -> int: ...
    def GetHeight(self) -> float: ...
    def GetHeightMaxValue(self) -> float: ...
    def GetHeightMinValue(self) -> float: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> float: ...
    def GetOffsetMaxValue(self) -> float: ...
    def GetOffsetMinValue(self) -> float: ...
    def GetPlotComponent(self) -> int: ...
    def GetPlotMode(self) -> int: ...
    def GetRadius(self) -> float: ...
    def GetRadiusMaxValue(self) -> float: ...
    def GetRadiusMinValue(self) -> float: ...
    def GetUseDefaultNormal(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkArcPlotter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkArcPlotter': ...
    def SetCamera(self, __a:'vtkCamera') -> None: ...
    @overload
    def SetDefaultNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDefaultNormal(self, _arg:Sequence[float]) -> None: ...
    def SetFieldDataArray(self, _arg:int) -> None: ...
    def SetHeight(self, _arg:float) -> None: ...
    def SetOffset(self, _arg:float) -> None: ...
    def SetPlotComponent(self, _arg:int) -> None: ...
    def SetPlotMode(self, _arg:int) -> None: ...
    def SetPlotModeToPlotFieldData(self) -> None: ...
    def SetPlotModeToPlotNormals(self) -> None: ...
    def SetPlotModeToPlotScalars(self) -> None: ...
    def SetPlotModeToPlotTCoords(self) -> None: ...
    def SetPlotModeToPlotTensors(self) -> None: ...
    def SetPlotModeToPlotVectors(self) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetUseDefaultNormal(self, _arg:int) -> None: ...
    def UseDefaultNormalOff(self) -> None: ...
    def UseDefaultNormalOn(self) -> None: ...

class vtkAxesActor(vtkmodules.vtkRenderingCore.vtkProp3D):
    CONE_TIP:int
    CYLINDER_SHAFT:int
    LINE_SHAFT:int
    SPHERE_TIP:int
    USER_DEFINED_SHAFT:int
    USER_DEFINED_TIP:int
    axis_labels:'getset_descriptor'
    bounds:'getset_descriptor'
    cone_radius:'getset_descriptor'
    cone_resolution:'getset_descriptor'
    cylinder_radius:'getset_descriptor'
    cylinder_resolution:'getset_descriptor'
    m_time:'getset_descriptor'
    normalized_label_position:'getset_descriptor'
    normalized_shaft_length:'getset_descriptor'
    normalized_tip_length:'getset_descriptor'
    redraw_m_time:'getset_descriptor'
    shaft_type:'getset_descriptor'
    sphere_radius:'getset_descriptor'
    sphere_resolution:'getset_descriptor'
    tip_type:'getset_descriptor'
    total_length:'getset_descriptor'
    user_defined_shaft:'getset_descriptor'
    user_defined_tip:'getset_descriptor'
    x_axis_caption_actor2d:'getset_descriptor'
    x_axis_label_text:'getset_descriptor'
    x_axis_shaft_property:'getset_descriptor'
    x_axis_tip_property:'getset_descriptor'
    y_axis_caption_actor2d:'getset_descriptor'
    y_axis_label_text:'getset_descriptor'
    y_axis_shaft_property:'getset_descriptor'
    y_axis_tip_property:'getset_descriptor'
    z_axis_caption_actor2d:'getset_descriptor'
    z_axis_label_text:'getset_descriptor'
    z_axis_shaft_property:'getset_descriptor'
    z_axis_tip_property:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AxisLabelsOff(self) -> None: ...
    def AxisLabelsOn(self) -> None: ...
    def GetActors(self, __a:'vtkPropCollection') -> None: ...
    def GetAxisLabels(self) -> int: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetConeRadius(self) -> float: ...
    def GetConeRadiusMaxValue(self) -> float: ...
    def GetConeRadiusMinValue(self) -> float: ...
    def GetConeResolution(self) -> int: ...
    def GetConeResolutionMaxValue(self) -> int: ...
    def GetConeResolutionMinValue(self) -> int: ...
    def GetCylinderRadius(self) -> float: ...
    def GetCylinderRadiusMaxValue(self) -> float: ...
    def GetCylinderRadiusMinValue(self) -> float: ...
    def GetCylinderResolution(self) -> int: ...
    def GetCylinderResolutionMaxValue(self) -> int: ...
    def GetCylinderResolutionMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNormalizedLabelPosition(self) -> Tuple[float, float, float]: ...
    def GetNormalizedShaftLength(self) -> Tuple[float, float, float]: ...
    def GetNormalizedTipLength(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRedrawMTime(self) -> int: ...
    def GetShaftType(self) -> int: ...
    def GetSphereRadius(self) -> float: ...
    def GetSphereRadiusMaxValue(self) -> float: ...
    def GetSphereRadiusMinValue(self) -> float: ...
    def GetSphereResolution(self) -> int: ...
    def GetSphereResolutionMaxValue(self) -> int: ...
    def GetSphereResolutionMinValue(self) -> int: ...
    def GetTipType(self) -> int: ...
    def GetTotalLength(self) -> Tuple[float, float, float]: ...
    def GetUserDefinedShaft(self) -> 'vtkPolyData': ...
    def GetUserDefinedTip(self) -> 'vtkPolyData': ...
    def GetXAxisCaptionActor2D(self) -> 'vtkCaptionActor2D': ...
    def GetXAxisLabelText(self) -> str: ...
    def GetXAxisShaftProperty(self) -> 'vtkProperty': ...
    def GetXAxisTipProperty(self) -> 'vtkProperty': ...
    def GetYAxisCaptionActor2D(self) -> 'vtkCaptionActor2D': ...
    def GetYAxisLabelText(self) -> str: ...
    def GetYAxisShaftProperty(self) -> 'vtkProperty': ...
    def GetYAxisTipProperty(self) -> 'vtkProperty': ...
    def GetZAxisCaptionActor2D(self) -> 'vtkCaptionActor2D': ...
    def GetZAxisLabelText(self) -> str: ...
    def GetZAxisShaftProperty(self) -> 'vtkProperty': ...
    def GetZAxisTipProperty(self) -> 'vtkProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAxesActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAxesActor': ...
    def SetAxisLabels(self, _arg:int) -> None: ...
    def SetConeRadius(self, _arg:float) -> None: ...
    def SetConeResolution(self, _arg:int) -> None: ...
    def SetCylinderRadius(self, _arg:float) -> None: ...
    def SetCylinderResolution(self, _arg:int) -> None: ...
    @overload
    def SetNormalizedLabelPosition(self, v:MutableSequence[float]) -> None: ...
    @overload
    def SetNormalizedLabelPosition(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetNormalizedShaftLength(self, v:MutableSequence[float]) -> None: ...
    @overload
    def SetNormalizedShaftLength(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetNormalizedTipLength(self, v:MutableSequence[float]) -> None: ...
    @overload
    def SetNormalizedTipLength(self, x:float, y:float, z:float) -> None: ...
    def SetShaftType(self, type:int) -> None: ...
    def SetShaftTypeToCylinder(self) -> None: ...
    def SetShaftTypeToLine(self) -> None: ...
    def SetShaftTypeToUserDefined(self) -> None: ...
    def SetSphereRadius(self, _arg:float) -> None: ...
    def SetSphereResolution(self, _arg:int) -> None: ...
    def SetTipType(self, type:int) -> None: ...
    def SetTipTypeToCone(self) -> None: ...
    def SetTipTypeToSphere(self) -> None: ...
    def SetTipTypeToUserDefined(self) -> None: ...
    @overload
    def SetTotalLength(self, v:MutableSequence[float]) -> None: ...
    @overload
    def SetTotalLength(self, x:float, y:float, z:float) -> None: ...
    def SetUserDefinedShaft(self, __a:'vtkPolyData') -> None: ...
    def SetUserDefinedTip(self, __a:'vtkPolyData') -> None: ...
    def SetXAxisLabelText(self, _arg:str) -> None: ...
    def SetYAxisLabelText(self, _arg:str) -> None: ...
    def SetZAxisLabelText(self, _arg:str) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkAxisActor(vtkmodules.vtkRenderingCore.vtkActor):
    class AlignLocation(int): ...
    class AxisPosition(int): ...
    class AxisType(int): ...
    class TickLocation(int): ...
    VTK_ALIGN_BOTTOM:'AlignLocation'
    VTK_ALIGN_POINT1:'AlignLocation'
    VTK_ALIGN_POINT2:'AlignLocation'
    VTK_ALIGN_TOP:'AlignLocation'
    VTK_AXIS_POS_MAXMAX:'AxisPosition'
    VTK_AXIS_POS_MAXMIN:'AxisPosition'
    VTK_AXIS_POS_MINMAX:'AxisPosition'
    VTK_AXIS_POS_MINMIN:'AxisPosition'
    VTK_AXIS_TYPE_X:'AxisType'
    VTK_AXIS_TYPE_Y:'AxisType'
    VTK_AXIS_TYPE_Z:'AxisType'
    VTK_TICKS_BOTH:'TickLocation'
    VTK_TICKS_INSIDE:'TickLocation'
    VTK_TICKS_OUTSIDE:'TickLocation'
    axis_base_for_x:'getset_descriptor'
    axis_base_for_y:'getset_descriptor'
    axis_base_for_z:'getset_descriptor'
    axis_lines_property:'getset_descriptor'
    axis_main_line_property:'getset_descriptor'
    axis_major_ticks_property:'getset_descriptor'
    axis_minor_ticks_property:'getset_descriptor'
    axis_on_origin:'getset_descriptor'
    axis_position:'getset_descriptor'
    axis_type:'getset_descriptor'
    axis_visibility:'getset_descriptor'
    bounds:'getset_descriptor'
    calculate_label_offset:'getset_descriptor'
    calculate_title_offset:'getset_descriptor'
    camera:'getset_descriptor'
    delta_minor:'getset_descriptor'
    delta_range_major:'getset_descriptor'
    delta_range_minor:'getset_descriptor'
    draw_gridlines:'getset_descriptor'
    draw_gridlines_location:'getset_descriptor'
    draw_gridpolys:'getset_descriptor'
    draw_inner_gridlines:'getset_descriptor'
    exponent:'getset_descriptor'
    exponent_actor:'getset_descriptor'
    exponent_location:'getset_descriptor'
    exponent_offset:'getset_descriptor'
    exponent_prop3d:'getset_descriptor'
    exponent_visibility:'getset_descriptor'
    gridline_x_length:'getset_descriptor'
    gridline_y_length:'getset_descriptor'
    gridline_z_length:'getset_descriptor'
    gridlines_property:'getset_descriptor'
    gridpolys_property:'getset_descriptor'
    horizontal_offset_y_title2d:'getset_descriptor'
    inner_gridlines_property:'getset_descriptor'
    label_format:'getset_descriptor'
    label_offset:'getset_descriptor'
    label_scale:'getset_descriptor'
    label_text_property:'getset_descriptor'
    label_visibility:'getset_descriptor'
    labels:'getset_descriptor'
    last_major_tick_point_correction:'getset_descriptor'
    log:'getset_descriptor'
    major_range_start:'getset_descriptor'
    major_tick_size:'getset_descriptor'
    minor_range_start:'getset_descriptor'
    minor_start:'getset_descriptor'
    minor_tick_size:'getset_descriptor'
    minor_ticks_visible:'getset_descriptor'
    number_of_labels_built:'getset_descriptor'
    point1:'getset_descriptor'
    point1_coordinate:'getset_descriptor'
    point2:'getset_descriptor'
    point2_coordinate:'getset_descriptor'
    range:'getset_descriptor'
    save_title_position:'getset_descriptor'
    screen_size:'getset_descriptor'
    tick_location:'getset_descriptor'
    tick_visibility:'getset_descriptor'
    title:'getset_descriptor'
    title_actor:'getset_descriptor'
    title_align_location:'getset_descriptor'
    title_offset:'getset_descriptor'
    title_prop3d:'getset_descriptor'
    title_scale:'getset_descriptor'
    title_text_property:'getset_descriptor'
    title_visibility:'getset_descriptor'
    use2d_mode:'getset_descriptor'
    use_text_actor3d:'getset_descriptor'
    vertical_offset_x_title2d:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AxisVisibilityOff(self) -> None: ...
    def AxisVisibilityOn(self) -> None: ...
    def BuildAxis(self, viewport:'vtkViewport', __b:bool) -> None: ...
    def CalculateLabelOffsetOff(self) -> None: ...
    def CalculateLabelOffsetOn(self) -> None: ...
    def CalculateTitleOffsetOff(self) -> None: ...
    def CalculateTitleOffsetOn(self) -> None: ...
    def ComputeMaxLabelLength(self, __a:Sequence[float]) -> float: ...
    def ComputeTitleLength(self, __a:Sequence[float]) -> float: ...
    def DrawGridlinesOff(self) -> None: ...
    def DrawGridlinesOn(self) -> None: ...
    def DrawGridlinesOnlyOff(self) -> None: ...
    def DrawGridlinesOnlyOn(self) -> None: ...
    def DrawGridpolysOff(self) -> None: ...
    def DrawGridpolysOn(self) -> None: ...
    def DrawInnerGridlinesOff(self) -> None: ...
    def DrawInnerGridlinesOn(self) -> None: ...
    def ExponentVisibilityOff(self) -> None: ...
    def ExponentVisibilityOn(self) -> None: ...
    def GetAxisBaseForX(self) -> Tuple[float, float, float]: ...
    def GetAxisBaseForY(self) -> Tuple[float, float, float]: ...
    def GetAxisBaseForZ(self) -> Tuple[float, float, float]: ...
    def GetAxisLinesProperty(self) -> 'vtkProperty': ...
    def GetAxisMainLineProperty(self) -> 'vtkProperty': ...
    def GetAxisMajorTicksProperty(self) -> 'vtkProperty': ...
    def GetAxisMinorTicksProperty(self) -> 'vtkProperty': ...
    def GetAxisOnOrigin(self) -> bool: ...
    def GetAxisPosition(self) -> int: ...
    def GetAxisPositionMaxValue(self) -> int: ...
    def GetAxisPositionMinValue(self) -> int: ...
    def GetAxisType(self) -> int: ...
    def GetAxisTypeMaxValue(self) -> int: ...
    def GetAxisTypeMinValue(self) -> int: ...
    def GetAxisVisibility(self) -> bool: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCalculateLabelOffset(self) -> bool: ...
    def GetCalculateTitleOffset(self) -> bool: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetDeltaMajor(self, axis:int) -> float: ...
    def GetDeltaMinor(self) -> float: ...
    def GetDeltaRangeMajor(self) -> float: ...
    def GetDeltaRangeMinor(self) -> float: ...
    def GetDrawGridlines(self) -> bool: ...
    def GetDrawGridlinesLocation(self) -> int: ...
    def GetDrawGridlinesOnly(self) -> bool: ...
    def GetDrawGridpolys(self) -> bool: ...
    def GetDrawInnerGridlines(self) -> bool: ...
    def GetExponent(self) -> str: ...
    def GetExponentActor(self) -> 'vtkAxisFollower': ...
    def GetExponentLocation(self) -> int: ...
    def GetExponentOffset(self) -> float: ...
    def GetExponentProp3D(self) -> 'vtkProp3DAxisFollower': ...
    def GetExponentVisibility(self) -> bool: ...
    def GetGridlineXLength(self) -> float: ...
    def GetGridlineYLength(self) -> float: ...
    def GetGridlineZLength(self) -> float: ...
    def GetGridlinesProperty(self) -> 'vtkProperty': ...
    def GetGridpolysProperty(self) -> 'vtkProperty': ...
    def GetHorizontalOffsetYTitle2D(self) -> float: ...
    def GetInnerGridlinesProperty(self) -> 'vtkProperty': ...
    def GetLabelFormat(self) -> str: ...
    def GetLabelOffset(self) -> float: ...
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetLabelVisibility(self) -> bool: ...
    def GetLastMajorTickPointCorrection(self) -> bool: ...
    def GetLog(self) -> bool: ...
    def GetMajorRangeStart(self) -> float: ...
    def GetMajorStart(self, axis:int) -> float: ...
    def GetMajorTickSize(self) -> float: ...
    def GetMinorRangeStart(self) -> float: ...
    def GetMinorStart(self) -> float: ...
    def GetMinorTickSize(self) -> float: ...
    def GetMinorTicksVisible(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabelsBuilt(self) -> int: ...
    def GetPoint1(self) -> Pointer: ...
    def GetPoint1Coordinate(self) -> 'vtkCoordinate': ...
    def GetPoint2(self) -> Pointer: ...
    def GetPoint2Coordinate(self) -> 'vtkCoordinate': ...
    def GetRange(self) -> Tuple[float, float]: ...
    def GetSaveTitlePosition(self) -> int: ...
    def GetScreenSize(self) -> float: ...
    def GetTickLocation(self) -> int: ...
    def GetTickLocationMaxValue(self) -> int: ...
    def GetTickLocationMinValue(self) -> int: ...
    def GetTickVisibility(self) -> bool: ...
    def GetTitle(self) -> str: ...
    def GetTitleActor(self) -> 'vtkAxisFollower': ...
    def GetTitleAlignLocation(self) -> int: ...
    @overload
    def GetTitleOffset(self) -> float: ...
    @overload
    def GetTitleOffset(self, titleOffsetX:float, titleOffsetY:float) -> None: ...
    def GetTitleProp3D(self) -> 'vtkProp3DAxisFollower': ...
    def GetTitleTextProperty(self) -> 'vtkTextProperty': ...
    def GetTitleVisibility(self) -> bool: ...
    def GetUse2DMode(self) -> bool: ...
    def GetUseTextActor3D(self) -> bool: ...
    def GetVerticalOffsetXTitle2D(self) -> float: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def LastMajorTickPointCorrectionOff(self) -> None: ...
    def LastMajorTickPointCorrectionOn(self) -> None: ...
    def LogOff(self) -> None: ...
    def LogOn(self) -> None: ...
    def MinorTicksVisibleOff(self) -> None: ...
    def MinorTicksVisibleOn(self) -> None: ...
    def NewInstance(self) -> 'vtkAxisActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAxisActor': ...
    @overload
    def SetAxisBaseForX(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisBaseForX(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetAxisBaseForY(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisBaseForY(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetAxisBaseForZ(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisBaseForZ(self, _arg:Sequence[float]) -> None: ...
    def SetAxisLinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetAxisMainLineProperty(self, __a:'vtkProperty') -> None: ...
    def SetAxisMajorTicksProperty(self, __a:'vtkProperty') -> None: ...
    def SetAxisMinorTicksProperty(self, __a:'vtkProperty') -> None: ...
    def SetAxisOnOrigin(self, _arg:bool) -> None: ...
    def SetAxisPosition(self, _arg:int) -> None: ...
    def SetAxisPositionToMaxMax(self) -> None: ...
    def SetAxisPositionToMaxMin(self) -> None: ...
    def SetAxisPositionToMinMax(self) -> None: ...
    def SetAxisPositionToMinMin(self) -> None: ...
    def SetAxisType(self, _arg:int) -> None: ...
    def SetAxisTypeToX(self) -> None: ...
    def SetAxisTypeToY(self) -> None: ...
    def SetAxisTypeToZ(self) -> None: ...
    def SetAxisVisibility(self, _arg:bool) -> None: ...
    @overload
    def SetBounds(self, bounds:Sequence[float]) -> None: ...
    @overload
    def SetBounds(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    def SetCalculateLabelOffset(self, _arg:bool) -> None: ...
    def SetCalculateTitleOffset(self, _arg:bool) -> None: ...
    def SetCamera(self, __a:'vtkCamera') -> None: ...
    def SetDeltaMajor(self, axis:int, value:float) -> None: ...
    def SetDeltaMinor(self, _arg:float) -> None: ...
    def SetDeltaRangeMajor(self, _arg:float) -> None: ...
    def SetDeltaRangeMinor(self, _arg:float) -> None: ...
    def SetDrawGridlines(self, _arg:bool) -> None: ...
    def SetDrawGridlinesLocation(self, _arg:int) -> None: ...
    def SetDrawGridlinesOnly(self, _arg:bool) -> None: ...
    def SetDrawGridpolys(self, _arg:bool) -> None: ...
    def SetDrawInnerGridlines(self, _arg:bool) -> None: ...
    def SetExponent(self, t:str) -> None: ...
    def SetExponentLocation(self, location:int) -> None: ...
    def SetExponentOffset(self, _arg:float) -> None: ...
    def SetExponentVisibility(self, _arg:bool) -> None: ...
    def SetGridlineXLength(self, _arg:float) -> None: ...
    def SetGridlineYLength(self, _arg:float) -> None: ...
    def SetGridlineZLength(self, _arg:float) -> None: ...
    def SetGridlinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetGridpolysProperty(self, __a:'vtkProperty') -> None: ...
    def SetHorizontalOffsetYTitle2D(self, _arg:float) -> None: ...
    def SetInnerGridlinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetLabelOffset(self, _arg:float) -> None: ...
    @overload
    def SetLabelScale(self, scale:float) -> None: ...
    @overload
    def SetLabelScale(self, labelIndex:int, scale:float) -> None: ...
    def SetLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetLabelVisibility(self, _arg:bool) -> None: ...
    def SetLabels(self, labels:'vtkStringArray') -> None: ...
    def SetLastMajorTickPointCorrection(self, _arg:bool) -> None: ...
    def SetLog(self, _arg:bool) -> None: ...
    def SetMajorRangeStart(self, _arg:float) -> None: ...
    def SetMajorStart(self, axis:int, value:float) -> None: ...
    def SetMajorTickSize(self, _arg:float) -> None: ...
    def SetMinorRangeStart(self, _arg:float) -> None: ...
    def SetMinorStart(self, _arg:float) -> None: ...
    def SetMinorTickSize(self, _arg:float) -> None: ...
    def SetMinorTicksVisible(self, _arg:bool) -> None: ...
    @overload
    def SetPoint1(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetPoint1(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetPoint2(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetPoint2(self, x:float, y:float, z:float) -> None: ...
    @overload
    def SetRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetRange(self, _arg:Sequence[float]) -> None: ...
    def SetSaveTitlePosition(self, _arg:int) -> None: ...
    def SetScreenSize(self, _arg:float) -> None: ...
    def SetTickLocation(self, _arg:int) -> None: ...
    def SetTickLocationToBoth(self) -> None: ...
    def SetTickLocationToInside(self) -> None: ...
    def SetTickLocationToOutside(self) -> None: ...
    def SetTickVisibility(self, _arg:bool) -> None: ...
    def SetTitle(self, t:str) -> None: ...
    def SetTitleAlignLocation(self, location:int) -> None: ...
    @overload
    def SetTitleOffset(self, titleOffsetY:float) -> None: ...
    @overload
    def SetTitleOffset(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetTitleOffset(self, _arg:Sequence[float]) -> None: ...
    def SetTitleScale(self, scale:float) -> None: ...
    def SetTitleTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetTitleVisibility(self, _arg:bool) -> None: ...
    def SetUse2DMode(self, _arg:bool) -> None: ...
    def SetUseTextActor3D(self, _arg:bool) -> None: ...
    def SetVerticalOffsetXTitle2D(self, _arg:float) -> None: ...
    def TickVisibilityOff(self) -> None: ...
    def TickVisibilityOn(self) -> None: ...
    def TitleVisibilityOff(self) -> None: ...
    def TitleVisibilityOn(self) -> None: ...

class vtkAxisActor2D(vtkmodules.vtkRenderingCore.vtkActor2D):
    class LabelMax(int): ...
    VTK_MAX_LABELS:'LabelMax'
    adjust_labels:'getset_descriptor'
    adjusted_number_of_labels:'getset_descriptor'
    axis_visibility:'getset_descriptor'
    font_factor:'getset_descriptor'
    label_factor:'getset_descriptor'
    label_format:'getset_descriptor'
    label_text_property:'getset_descriptor'
    label_visibility:'getset_descriptor'
    minor_tick_length:'getset_descriptor'
    notation:'getset_descriptor'
    number_of_labels:'getset_descriptor'
    number_of_labels_max_value:'getset_descriptor'
    number_of_labels_min_value:'getset_descriptor'
    number_of_minor_ticks:'getset_descriptor'
    number_of_minor_ticks_max_value:'getset_descriptor'
    number_of_minor_ticks_min_value:'getset_descriptor'
    point1:'getset_descriptor'
    point1_coordinate:'getset_descriptor'
    point2:'getset_descriptor'
    point2_coordinate:'getset_descriptor'
    precision:'getset_descriptor'
    range:'getset_descriptor'
    ruler_distance:'getset_descriptor'
    ruler_mode:'getset_descriptor'
    size_font_relative_to_axis:'getset_descriptor'
    skip_first_tick:'getset_descriptor'
    snap_labels_to_grid:'getset_descriptor'
    tick_length:'getset_descriptor'
    tick_offset:'getset_descriptor'
    tick_positions:'getset_descriptor'
    tick_visibility:'getset_descriptor'
    title:'getset_descriptor'
    title_position:'getset_descriptor'
    title_text_property:'getset_descriptor'
    title_visibility:'getset_descriptor'
    use_font_size_from_property:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AdjustLabelsOff(self) -> None: ...
    def AdjustLabelsOn(self) -> None: ...
    def AxisVisibilityOff(self) -> None: ...
    def AxisVisibilityOn(self) -> None: ...
    @staticmethod
    def ComputeRange(inRange:MutableSequence[float], outRange:MutableSequence[float], inNumTicks:int, outNumTicks:int, interval:float) -> None: ...
    def GetAdjustLabels(self) -> int: ...
    def GetAdjustedNumberOfLabels(self) -> int: ...
    @overload
    def GetAdjustedRange(self) -> Pointer: ...
    @overload
    def GetAdjustedRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def GetAdjustedRange(self, _arg:MutableSequence[float]) -> None: ...
    def GetAxisVisibility(self) -> int: ...
    def GetFontFactor(self) -> float: ...
    def GetFontFactorMaxValue(self) -> float: ...
    def GetFontFactorMinValue(self) -> float: ...
    def GetLabelFactor(self) -> float: ...
    def GetLabelFactorMaxValue(self) -> float: ...
    def GetLabelFactorMinValue(self) -> float: ...
    def GetLabelFormat(self) -> str: ...
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetLabelVisibility(self) -> int: ...
    def GetMinorTickLength(self) -> int: ...
    def GetMinorTickLengthMaxValue(self) -> int: ...
    def GetMinorTickLengthMinValue(self) -> int: ...
    def GetNotation(self) -> int: ...
    def GetNotationMaxValue(self) -> int: ...
    def GetNotationMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    def GetNumberOfLabelsMaxValue(self) -> int: ...
    def GetNumberOfLabelsMinValue(self) -> int: ...
    def GetNumberOfMinorTicks(self) -> int: ...
    def GetNumberOfMinorTicksMaxValue(self) -> int: ...
    def GetNumberOfMinorTicksMinValue(self) -> int: ...
    def GetPoint1(self) -> Pointer: ...
    def GetPoint1Coordinate(self) -> 'vtkCoordinate': ...
    def GetPoint2(self) -> Pointer: ...
    def GetPoint2Coordinate(self) -> 'vtkCoordinate': ...
    def GetPrecision(self) -> int: ...
    def GetPrecisionMaxValue(self) -> int: ...
    def GetPrecisionMinValue(self) -> int: ...
    def GetRange(self) -> Tuple[float, float]: ...
    def GetRulerDistance(self) -> float: ...
    def GetRulerDistanceMaxValue(self) -> float: ...
    def GetRulerDistanceMinValue(self) -> float: ...
    def GetRulerMode(self) -> int: ...
    def GetSizeFontRelativeToAxis(self) -> int: ...
    def GetSkipFirstTick(self) -> bool: ...
    def GetSnapLabelsToGrid(self) -> bool: ...
    def GetTickLength(self) -> int: ...
    def GetTickLengthMaxValue(self) -> int: ...
    def GetTickLengthMinValue(self) -> int: ...
    def GetTickOffset(self) -> int: ...
    def GetTickOffsetMaxValue(self) -> int: ...
    def GetTickOffsetMinValue(self) -> int: ...
    def GetTickPositions(self) -> 'vtkPoints': ...
    def GetTickVisibility(self) -> int: ...
    def GetTitle(self) -> str: ...
    def GetTitlePosition(self) -> float: ...
    def GetTitleTextProperty(self) -> 'vtkTextProperty': ...
    def GetTitleVisibility(self) -> int: ...
    def GetUseFontSizeFromProperty(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkAxisActor2D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    def RulerModeOff(self) -> None: ...
    def RulerModeOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAxisActor2D': ...
    def SetAdjustLabels(self, _arg:int) -> None: ...
    def SetAxisVisibility(self, _arg:int) -> None: ...
    def SetFontFactor(self, _arg:float) -> None: ...
    def SetLabelFactor(self, _arg:float) -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetLabelVisibility(self, _arg:int) -> None: ...
    def SetMinorTickLength(self, _arg:int) -> None: ...
    def SetNotation(self, _arg:int) -> None: ...
    def SetNumberOfLabels(self, _arg:int) -> None: ...
    def SetNumberOfMinorTicks(self, _arg:int) -> None: ...
    @overload
    def SetPoint1(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetPoint1(self, x:float, y:float) -> None: ...
    @overload
    def SetPoint2(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetPoint2(self, x:float, y:float) -> None: ...
    def SetPrecision(self, _arg:int) -> None: ...
    @overload
    def SetRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetRange(self, _arg:Sequence[float]) -> None: ...
    def SetRulerDistance(self, _arg:float) -> None: ...
    def SetRulerMode(self, _arg:int) -> None: ...
    def SetSizeFontRelativeToAxis(self, _arg:int) -> None: ...
    def SetSkipFirstTick(self, _arg:bool) -> None: ...
    def SetSnapLabelsToGrid(self, _arg:bool) -> None: ...
    def SetTickLength(self, _arg:int) -> None: ...
    def SetTickOffset(self, _arg:int) -> None: ...
    def SetTickVisibility(self, _arg:int) -> None: ...
    def SetTitle(self, _arg:str) -> None: ...
    def SetTitlePosition(self, _arg:float) -> None: ...
    def SetTitleTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetTitleVisibility(self, _arg:int) -> None: ...
    def SetUseFontSizeFromProperty(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def SizeFontRelativeToAxisOff(self) -> None: ...
    def SizeFontRelativeToAxisOn(self) -> None: ...
    def SkipFirstTickOff(self) -> None: ...
    def SkipFirstTickOn(self) -> None: ...
    def SnapLabelsToGridOff(self) -> None: ...
    def SnapLabelsToGridOn(self) -> None: ...
    def TickVisibilityOff(self) -> None: ...
    def TickVisibilityOn(self) -> None: ...
    def TitleVisibilityOff(self) -> None: ...
    def TitleVisibilityOn(self) -> None: ...
    def UpdateGeometryAndRenderOpaqueGeometry(self, viewport:'vtkViewport', render:bool) -> int: ...
    def UseFontSizeFromPropertyOff(self) -> None: ...
    def UseFontSizeFromPropertyOn(self) -> None: ...

class vtkAxisFollower(vtkmodules.vtkRenderingCore.vtkFollower):
    auto_center:'getset_descriptor'
    axis:'getset_descriptor'
    distance_lod_threshold:'getset_descriptor'
    enable_distance_lod:'getset_descriptor'
    enable_view_angle_lod:'getset_descriptor'
    screen_offset:'getset_descriptor'
    screen_offset_vector:'getset_descriptor'
    view_angle_lod_threshold:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutoCenterOff(self) -> None: ...
    def AutoCenterOn(self) -> None: ...
    @staticmethod
    def AutoScale(viewport:'vtkViewport', camera:'vtkCamera', screenSize:float, position:MutableSequence[float]) -> float: ...
    def ComputeMatrix(self) -> None: ...
    def ComputeTransformMatrix(self, ren:'vtkRenderer') -> None: ...
    def GetAutoCenter(self) -> int: ...
    def GetAxis(self) -> 'vtkAxisActor': ...
    def GetDistanceLODThreshold(self) -> float: ...
    def GetDistanceLODThresholdMaxValue(self) -> float: ...
    def GetDistanceLODThresholdMinValue(self) -> float: ...
    def GetEnableDistanceLOD(self) -> int: ...
    def GetEnableViewAngleLOD(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScreenOffset(self) -> float: ...
    def GetScreenOffsetVector(self) -> Tuple[float, float]: ...
    def GetViewAngleLODThreshold(self) -> float: ...
    def GetViewAngleLODThresholdMaxValue(self) -> float: ...
    def GetViewAngleLODThresholdMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAxisFollower': ...
    def Render(self, ren:'vtkRenderer') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAxisFollower': ...
    def SetAutoCenter(self, _arg:int) -> None: ...
    def SetAxis(self, __a:'vtkAxisActor') -> None: ...
    def SetDistanceLODThreshold(self, _arg:float) -> None: ...
    def SetEnableDistanceLOD(self, _arg:int) -> None: ...
    def SetEnableViewAngleLOD(self, _arg:int) -> None: ...
    def SetScreenOffset(self, offset:float) -> None: ...
    @overload
    def SetScreenOffsetVector(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScreenOffsetVector(self, _arg:Sequence[float]) -> None: ...
    def SetViewAngleLODThreshold(self, _arg:float) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkBarChartActor(vtkmodules.vtkRenderingCore.vtkActor2D):
    input:'getset_descriptor'
    label_text_property:'getset_descriptor'
    label_visibility:'getset_descriptor'
    legend_actor:'getset_descriptor'
    legend_visibility:'getset_descriptor'
    title:'getset_descriptor'
    title_text_property:'getset_descriptor'
    title_visibility:'getset_descriptor'
    y_title:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetBarColor(self, i:int) -> Pointer: ...
    def GetBarLabel(self, i:int) -> str: ...
    def GetInput(self) -> 'vtkDataObject': ...
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetLabelVisibility(self) -> int: ...
    def GetLegendActor(self) -> 'vtkLegendBoxActor': ...
    def GetLegendVisibility(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTitle(self) -> str: ...
    def GetTitleTextProperty(self) -> 'vtkTextProperty': ...
    def GetTitleVisibility(self) -> int: ...
    def GetYTitle(self) -> str: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def LegendVisibilityOff(self) -> None: ...
    def LegendVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkBarChartActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBarChartActor': ...
    @overload
    def SetBarColor(self, i:int, r:float, g:float, b:float) -> None: ...
    @overload
    def SetBarColor(self, i:int, color:Sequence[float]) -> None: ...
    def SetBarLabel(self, i:int, __b:str) -> None: ...
    def SetInput(self, __a:'vtkDataObject') -> None: ...
    def SetLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetLabelVisibility(self, _arg:int) -> None: ...
    def SetLegendVisibility(self, _arg:int) -> None: ...
    def SetTitle(self, _arg:str) -> None: ...
    def SetTitleTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetTitleVisibility(self, _arg:int) -> None: ...
    def SetYTitle(self, _arg:str) -> None: ...
    def TitleVisibilityOff(self) -> None: ...
    def TitleVisibilityOn(self) -> None: ...

class vtkCaptionActor2D(vtkmodules.vtkRenderingCore.vtkActor2D):
    attach_edge_only:'getset_descriptor'
    attachment_point:'getset_descriptor'
    attachment_point_coordinate:'getset_descriptor'
    border:'getset_descriptor'
    caption:'getset_descriptor'
    caption_text_property:'getset_descriptor'
    leader:'getset_descriptor'
    leader_glyph:'getset_descriptor'
    leader_glyph_connection:'getset_descriptor'
    leader_glyph_data:'getset_descriptor'
    leader_glyph_size:'getset_descriptor'
    maximum_leader_glyph_size:'getset_descriptor'
    padding:'getset_descriptor'
    text_actor:'getset_descriptor'
    three_dimensional_leader:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AttachEdgeOnlyOff(self) -> None: ...
    def AttachEdgeOnlyOn(self) -> None: ...
    def BorderOff(self) -> None: ...
    def BorderOn(self) -> None: ...
    def GetAttachEdgeOnly(self) -> int: ...
    def GetAttachmentPoint(self) -> Tuple[float, float, float]: ...
    def GetAttachmentPointCoordinate(self) -> 'vtkCoordinate': ...
    def GetBorder(self) -> int: ...
    def GetCaption(self) -> str: ...
    def GetCaptionTextProperty(self) -> 'vtkTextProperty': ...
    def GetLeader(self) -> int: ...
    def GetLeaderGlyph(self) -> 'vtkPolyData': ...
    def GetLeaderGlyphSize(self) -> float: ...
    def GetLeaderGlyphSizeMaxValue(self) -> float: ...
    def GetLeaderGlyphSizeMinValue(self) -> float: ...
    def GetMaximumLeaderGlyphSize(self) -> int: ...
    def GetMaximumLeaderGlyphSizeMaxValue(self) -> int: ...
    def GetMaximumLeaderGlyphSizeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPadding(self) -> int: ...
    def GetPaddingMaxValue(self) -> int: ...
    def GetPaddingMinValue(self) -> int: ...
    def GetTextActor(self) -> 'vtkTextActor': ...
    def GetThreeDimensionalLeader(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LeaderOff(self) -> None: ...
    def LeaderOn(self) -> None: ...
    def NewInstance(self) -> 'vtkCaptionActor2D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCaptionActor2D': ...
    def SetAttachEdgeOnly(self, _arg:int) -> None: ...
    @overload
    def SetAttachmentPoint(self, x:MutableSequence[float]) -> None: ...
    @overload
    def SetAttachmentPoint(self, x:float, y:float, z:float) -> None: ...
    def SetBorder(self, _arg:int) -> None: ...
    def SetCaption(self, caption:str) -> None: ...
    def SetCaptionTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetLeader(self, _arg:int) -> None: ...
    def SetLeaderGlyphConnection(self, __a:'vtkAlgorithmOutput') -> None: ...
    def SetLeaderGlyphData(self, __a:'vtkPolyData') -> None: ...
    def SetLeaderGlyphSize(self, _arg:float) -> None: ...
    def SetMaximumLeaderGlyphSize(self, _arg:int) -> None: ...
    def SetPadding(self, _arg:int) -> None: ...
    def SetThreeDimensionalLeader(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def ThreeDimensionalLeaderOff(self) -> None: ...
    def ThreeDimensionalLeaderOn(self) -> None: ...

class vtkConvexHull2D(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class HullShapes(int): ...
    BoundingRectangle:'HullShapes'
    ConvexHull:'HullShapes'
    hull_shape:'getset_descriptor'
    m_time:'getset_descriptor'
    min_hull_size_in_display:'getset_descriptor'
    min_hull_size_in_world:'getset_descriptor'
    outline:'getset_descriptor'
    renderer:'getset_descriptor'
    scale_factor:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    @staticmethod
    def CalculateBoundingRectangle(inPoints:'vtkPoints', outPoints:'vtkPoints', minimumHullSize:float=1.0) -> None: ...
    @staticmethod
    def CalculateConvexHull(inPoints:'vtkPoints', outPoints:'vtkPoints', minimumHullSize:float=1.0) -> None: ...
    def GetHullShape(self) -> int: ...
    def GetHullShapeMaxValue(self) -> int: ...
    def GetHullShapeMinValue(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetMinHullSizeInDisplay(self) -> int: ...
    def GetMinHullSizeInDisplayMaxValue(self) -> int: ...
    def GetMinHullSizeInDisplayMinValue(self) -> int: ...
    def GetMinHullSizeInWorld(self) -> float: ...
    def GetMinHullSizeInWorldMaxValue(self) -> float: ...
    def GetMinHullSizeInWorldMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutline(self) -> bool: ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def GetScaleFactor(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConvexHull2D': ...
    def OutlineOff(self) -> None: ...
    def OutlineOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConvexHull2D': ...
    def SetHullShape(self, _arg:int) -> None: ...
    def SetMinHullSizeInDisplay(self, _arg:int) -> None: ...
    def SetMinHullSizeInWorld(self, _arg:float) -> None: ...
    def SetOutline(self, _arg:bool) -> None: ...
    def SetRenderer(self, renderer:'vtkRenderer') -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...

class vtkCornerAnnotation(vtkmodules.vtkRenderingCore.vtkActor2D):
    class TextPosition(int): ...
    LeftEdge:'TextPosition'
    LowerEdge:'TextPosition'
    LowerLeft:'TextPosition'
    LowerRight:'TextPosition'
    NumTextPositions:int
    RightEdge:'TextPosition'
    UpperEdge:'TextPosition'
    UpperLeft:'TextPosition'
    UpperRight:'TextPosition'
    all_texts:'getset_descriptor'
    image_actor:'getset_descriptor'
    level_scale:'getset_descriptor'
    level_shift:'getset_descriptor'
    linear_font_scale_factor:'getset_descriptor'
    maximum_font_size:'getset_descriptor'
    maximum_line_height:'getset_descriptor'
    minimum_font_size:'getset_descriptor'
    nonlinear_font_scale_factor:'getset_descriptor'
    show_slice_and_image:'getset_descriptor'
    text_property:'getset_descriptor'
    window_level:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClearAllTexts(self) -> None: ...
    def CopyAllTextsFrom(self, ca:'vtkCornerAnnotation') -> None: ...
    def GetAllTexts(self) -> Tuple[str, str]: ...
    def GetImageActor(self) -> 'vtkImageActor': ...
    def GetLevelScale(self) -> float: ...
    def GetLevelShift(self) -> float: ...
    def GetLinearFontScaleFactor(self) -> float: ...
    def GetMaximumFontSize(self) -> int: ...
    def GetMaximumLineHeight(self) -> float: ...
    def GetMinimumFontSize(self) -> int: ...
    def GetNonlinearFontScaleFactor(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShowSliceAndImage(self) -> int: ...
    def GetText(self, i:int) -> str: ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def GetWindowLevel(self) -> 'vtkImageMapToWindowLevelColors': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCornerAnnotation': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCornerAnnotation': ...
    def SetAllTexts(self, values:Sequence[str]) -> None: ...
    def SetImageActor(self, __a:'vtkImageActor') -> None: ...
    def SetLevelScale(self, _arg:float) -> None: ...
    def SetLevelShift(self, _arg:float) -> None: ...
    def SetLinearFontScaleFactor(self, _arg:float) -> None: ...
    def SetMaximumFontSize(self, _arg:int) -> None: ...
    def SetMaximumLineHeight(self, _arg:float) -> None: ...
    def SetMinimumFontSize(self, _arg:int) -> None: ...
    def SetNonlinearFontScaleFactor(self, _arg:float) -> None: ...
    def SetShowSliceAndImage(self, _arg:int) -> None: ...
    def SetText(self, i:int, text:str) -> None: ...
    def SetTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetWindowLevel(self, __a:'vtkImageMapToWindowLevelColors') -> None: ...
    def ShowSliceAndImageOff(self) -> None: ...
    def ShowSliceAndImageOn(self) -> None: ...

class vtkCubeAxesActor(vtkmodules.vtkRenderingCore.vtkActor):
    class FlyMode(int): ...
    class GridVisibility(int): ...
    class TickLocation(int): ...
    VTK_FLY_CLOSEST_TRIAD:'FlyMode'
    VTK_FLY_FURTHEST_TRIAD:'FlyMode'
    VTK_FLY_OUTER_EDGES:'FlyMode'
    VTK_FLY_STATIC_EDGES:'FlyMode'
    VTK_FLY_STATIC_TRIAD:'FlyMode'
    VTK_GRID_LINES_ALL:'GridVisibility'
    VTK_GRID_LINES_CLOSEST:'GridVisibility'
    VTK_GRID_LINES_FURTHEST:'GridVisibility'
    VTK_TICKS_BOTH:'TickLocation'
    VTK_TICKS_INSIDE:'TickLocation'
    VTK_TICKS_OUTSIDE:'TickLocation'
    axis_base_for_x:'getset_descriptor'
    axis_base_for_y:'getset_descriptor'
    axis_base_for_z:'getset_descriptor'
    axis_origin:'getset_descriptor'
    bounds:'getset_descriptor'
    camera:'getset_descriptor'
    center_sticky_axes:'getset_descriptor'
    corner_offset:'getset_descriptor'
    distance_lod_threshold:'getset_descriptor'
    draw_x_gridlines:'getset_descriptor'
    draw_x_gridpolys:'getset_descriptor'
    draw_x_inner_gridlines:'getset_descriptor'
    draw_y_gridlines:'getset_descriptor'
    draw_y_gridpolys:'getset_descriptor'
    draw_y_inner_gridlines:'getset_descriptor'
    draw_z_gridlines:'getset_descriptor'
    draw_z_gridpolys:'getset_descriptor'
    draw_z_inner_gridlines:'getset_descriptor'
    enable_distance_lod:'getset_descriptor'
    enable_view_angle_lod:'getset_descriptor'
    fly_mode:'getset_descriptor'
    grid_line_location:'getset_descriptor'
    inertia:'getset_descriptor'
    label_offset:'getset_descriptor'
    oriented_bounds:'getset_descriptor'
    rebuild_axes:'getset_descriptor'
    save_title_position:'getset_descriptor'
    screen_size:'getset_descriptor'
    sticky_axes:'getset_descriptor'
    tick_location:'getset_descriptor'
    title_offset:'getset_descriptor'
    use2d_mode:'getset_descriptor'
    use_axis_origin:'getset_descriptor'
    use_oriented_bounds:'getset_descriptor'
    use_text_actor3d:'getset_descriptor'
    view_angle_lod_threshold:'getset_descriptor'
    x_axes_gridlines_property:'getset_descriptor'
    x_axes_gridpolys_property:'getset_descriptor'
    x_axes_inner_gridlines_property:'getset_descriptor'
    x_axes_label_property:'getset_descriptor'
    x_axes_lines_property:'getset_descriptor'
    x_axes_title_property:'getset_descriptor'
    x_axis_label_visibility:'getset_descriptor'
    x_axis_minor_tick_visibility:'getset_descriptor'
    x_axis_range:'getset_descriptor'
    x_axis_tick_visibility:'getset_descriptor'
    x_axis_visibility:'getset_descriptor'
    x_label_format:'getset_descriptor'
    x_title:'getset_descriptor'
    x_units:'getset_descriptor'
    y_axes_gridlines_property:'getset_descriptor'
    y_axes_gridpolys_property:'getset_descriptor'
    y_axes_inner_gridlines_property:'getset_descriptor'
    y_axes_label_property:'getset_descriptor'
    y_axes_lines_property:'getset_descriptor'
    y_axes_title_property:'getset_descriptor'
    y_axis_label_visibility:'getset_descriptor'
    y_axis_minor_tick_visibility:'getset_descriptor'
    y_axis_range:'getset_descriptor'
    y_axis_tick_visibility:'getset_descriptor'
    y_axis_visibility:'getset_descriptor'
    y_label_format:'getset_descriptor'
    y_title:'getset_descriptor'
    y_units:'getset_descriptor'
    z_axes_gridlines_property:'getset_descriptor'
    z_axes_gridpolys_property:'getset_descriptor'
    z_axes_inner_gridlines_property:'getset_descriptor'
    z_axes_label_property:'getset_descriptor'
    z_axes_lines_property:'getset_descriptor'
    z_axes_title_property:'getset_descriptor'
    z_axis_label_visibility:'getset_descriptor'
    z_axis_minor_tick_visibility:'getset_descriptor'
    z_axis_range:'getset_descriptor'
    z_axis_tick_visibility:'getset_descriptor'
    z_axis_visibility:'getset_descriptor'
    z_label_format:'getset_descriptor'
    z_title:'getset_descriptor'
    z_units:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CenterStickyAxesOff(self) -> None: ...
    def CenterStickyAxesOn(self) -> None: ...
    def DrawXGridlinesOff(self) -> None: ...
    def DrawXGridlinesOn(self) -> None: ...
    def DrawXGridpolysOff(self) -> None: ...
    def DrawXGridpolysOn(self) -> None: ...
    def DrawXInnerGridlinesOff(self) -> None: ...
    def DrawXInnerGridlinesOn(self) -> None: ...
    def DrawYGridlinesOff(self) -> None: ...
    def DrawYGridlinesOn(self) -> None: ...
    def DrawYGridpolysOff(self) -> None: ...
    def DrawYGridpolysOn(self) -> None: ...
    def DrawYInnerGridlinesOff(self) -> None: ...
    def DrawYInnerGridlinesOn(self) -> None: ...
    def DrawZGridlinesOff(self) -> None: ...
    def DrawZGridlinesOn(self) -> None: ...
    def DrawZGridpolysOff(self) -> None: ...
    def DrawZGridpolysOn(self) -> None: ...
    def DrawZInnerGridlinesOff(self) -> None: ...
    def DrawZInnerGridlinesOn(self) -> None: ...
    def GetAxisBaseForX(self) -> Tuple[float, float, float]: ...
    def GetAxisBaseForY(self) -> Tuple[float, float, float]: ...
    def GetAxisBaseForZ(self) -> Tuple[float, float, float]: ...
    def GetAxisLabels(self, axis:int) -> 'vtkStringArray': ...
    def GetAxisOrigin(self) -> Tuple[float, float, float]: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetCenterStickyAxes(self) -> bool: ...
    def GetCornerOffset(self) -> float: ...
    def GetDistanceLODThreshold(self) -> float: ...
    def GetDistanceLODThresholdMaxValue(self) -> float: ...
    def GetDistanceLODThresholdMinValue(self) -> float: ...
    def GetDrawXGridlines(self) -> bool: ...
    def GetDrawXGridpolys(self) -> bool: ...
    def GetDrawXInnerGridlines(self) -> bool: ...
    def GetDrawYGridlines(self) -> bool: ...
    def GetDrawYGridpolys(self) -> bool: ...
    def GetDrawYInnerGridlines(self) -> bool: ...
    def GetDrawZGridlines(self) -> bool: ...
    def GetDrawZGridpolys(self) -> bool: ...
    def GetDrawZInnerGridlines(self) -> bool: ...
    def GetEnableDistanceLOD(self) -> bool: ...
    def GetEnableViewAngleLOD(self) -> bool: ...
    def GetFlyMode(self) -> int: ...
    def GetFlyModeMaxValue(self) -> int: ...
    def GetFlyModeMinValue(self) -> int: ...
    def GetGridLineLocation(self) -> int: ...
    def GetInertia(self) -> int: ...
    def GetInertiaMaxValue(self) -> int: ...
    def GetInertiaMinValue(self) -> int: ...
    def GetLabelOffset(self) -> float: ...
    def GetLabelTextProperty(self, __a:int) -> 'vtkTextProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientedBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    def GetRebuildAxes(self) -> bool: ...
    @overload
    def GetRenderedBounds(self, rBounds:MutableSequence[float]) -> None: ...
    @overload
    def GetRenderedBounds(self) -> Pointer: ...
    def GetScreenSize(self) -> float: ...
    def GetStickyAxes(self) -> bool: ...
    def GetTickLocation(self) -> int: ...
    def GetTickLocationMaxValue(self) -> int: ...
    def GetTickLocationMinValue(self) -> int: ...
    @overload
    def GetTitleOffset(self) -> float: ...
    @overload
    def GetTitleOffset(self, titleOffsetX:float, titleOffsetY:float) -> None: ...
    def GetTitleTextProperty(self, __a:int) -> 'vtkTextProperty': ...
    def GetUse2DMode(self) -> bool: ...
    def GetUseAxisOrigin(self) -> bool: ...
    def GetUseOrientedBounds(self) -> bool: ...
    def GetUseTextActor3D(self) -> bool: ...
    def GetViewAngleLODThreshold(self) -> float: ...
    def GetViewAngleLODThresholdMaxValue(self) -> float: ...
    def GetViewAngleLODThresholdMinValue(self) -> float: ...
    def GetXAxesGridlinesProperty(self) -> 'vtkProperty': ...
    def GetXAxesGridpolysProperty(self) -> 'vtkProperty': ...
    def GetXAxesInnerGridlinesProperty(self) -> 'vtkProperty': ...
    def GetXAxesLabelProperty(self) -> 'vtkTextProperty': ...
    def GetXAxesLinesProperty(self) -> 'vtkProperty': ...
    def GetXAxesTitleProperty(self) -> 'vtkTextProperty': ...
    def GetXAxisLabelVisibility(self) -> bool: ...
    def GetXAxisMinorTickVisibility(self) -> bool: ...
    def GetXAxisRange(self) -> Tuple[float, float]: ...
    def GetXAxisTickVisibility(self) -> bool: ...
    def GetXAxisVisibility(self) -> bool: ...
    def GetXLabelFormat(self) -> str: ...
    def GetXTitle(self) -> str: ...
    def GetXUnits(self) -> str: ...
    def GetYAxesGridlinesProperty(self) -> 'vtkProperty': ...
    def GetYAxesGridpolysProperty(self) -> 'vtkProperty': ...
    def GetYAxesInnerGridlinesProperty(self) -> 'vtkProperty': ...
    def GetYAxesLabelProperty(self) -> 'vtkTextProperty': ...
    def GetYAxesLinesProperty(self) -> 'vtkProperty': ...
    def GetYAxesTitleProperty(self) -> 'vtkTextProperty': ...
    def GetYAxisLabelVisibility(self) -> bool: ...
    def GetYAxisMinorTickVisibility(self) -> bool: ...
    def GetYAxisRange(self) -> Tuple[float, float]: ...
    def GetYAxisTickVisibility(self) -> bool: ...
    def GetYAxisVisibility(self) -> bool: ...
    def GetYLabelFormat(self) -> str: ...
    def GetYTitle(self) -> str: ...
    def GetYUnits(self) -> str: ...
    def GetZAxesGridlinesProperty(self) -> 'vtkProperty': ...
    def GetZAxesGridpolysProperty(self) -> 'vtkProperty': ...
    def GetZAxesInnerGridlinesProperty(self) -> 'vtkProperty': ...
    def GetZAxesLabelProperty(self) -> 'vtkTextProperty': ...
    def GetZAxesLinesProperty(self) -> 'vtkProperty': ...
    def GetZAxesTitleProperty(self) -> 'vtkTextProperty': ...
    def GetZAxisLabelVisibility(self) -> bool: ...
    def GetZAxisMinorTickVisibility(self) -> bool: ...
    def GetZAxisRange(self) -> Tuple[float, float]: ...
    def GetZAxisTickVisibility(self) -> bool: ...
    def GetZAxisVisibility(self) -> bool: ...
    def GetZLabelFormat(self) -> str: ...
    def GetZTitle(self) -> str: ...
    def GetZUnits(self) -> str: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCubeAxesActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCubeAxesActor': ...
    @overload
    def SetAxisBaseForX(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisBaseForX(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetAxisBaseForY(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisBaseForY(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetAxisBaseForZ(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisBaseForZ(self, _arg:Sequence[float]) -> None: ...
    def SetAxisLabels(self, axis:int, value:'vtkStringArray') -> None: ...
    @overload
    def SetAxisOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisOrigin(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetCamera(self, __a:'vtkCamera') -> None: ...
    def SetCenterStickyAxes(self, _arg:bool) -> None: ...
    def SetCornerOffset(self, _arg:float) -> None: ...
    def SetDistanceLODThreshold(self, _arg:float) -> None: ...
    def SetDrawXGridlines(self, _arg:bool) -> None: ...
    def SetDrawXGridpolys(self, _arg:bool) -> None: ...
    def SetDrawXInnerGridlines(self, _arg:bool) -> None: ...
    def SetDrawYGridlines(self, _arg:bool) -> None: ...
    def SetDrawYGridpolys(self, _arg:bool) -> None: ...
    def SetDrawYInnerGridlines(self, _arg:bool) -> None: ...
    def SetDrawZGridlines(self, _arg:bool) -> None: ...
    def SetDrawZGridpolys(self, _arg:bool) -> None: ...
    def SetDrawZInnerGridlines(self, _arg:bool) -> None: ...
    def SetEnableDistanceLOD(self, _arg:bool) -> None: ...
    def SetEnableViewAngleLOD(self, _arg:bool) -> None: ...
    def SetFlyMode(self, _arg:int) -> None: ...
    def SetFlyModeToClosestTriad(self) -> None: ...
    def SetFlyModeToFurthestTriad(self) -> None: ...
    def SetFlyModeToOuterEdges(self) -> None: ...
    def SetFlyModeToStaticEdges(self) -> None: ...
    def SetFlyModeToStaticTriad(self) -> None: ...
    def SetGridLineLocation(self, _arg:int) -> None: ...
    def SetInertia(self, _arg:int) -> None: ...
    def SetLabelOffset(self, offset:float) -> None: ...
    def SetLabelScaling(self, __a:bool, __b:int, __c:int, __d:int) -> None: ...
    @overload
    def SetOrientedBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetOrientedBounds(self, _arg:Sequence[float]) -> None: ...
    def SetRebuildAxes(self, _arg:bool) -> None: ...
    def SetSaveTitlePosition(self, val:int) -> None: ...
    def SetScreenSize(self, screenSize:float) -> None: ...
    def SetStickyAxes(self, _arg:bool) -> None: ...
    def SetTickLocation(self, _arg:int) -> None: ...
    def SetTickLocationToBoth(self) -> None: ...
    def SetTickLocationToInside(self) -> None: ...
    def SetTickLocationToOutside(self) -> None: ...
    @overload
    def SetTitleOffset(self, titleOffsetY:float) -> None: ...
    @overload
    def SetTitleOffset(self, titleOffset:MutableSequence[float]) -> None: ...
    def SetUse2DMode(self, enable:bool) -> None: ...
    def SetUseAxisOrigin(self, _arg:bool) -> None: ...
    def SetUseOrientedBounds(self, _arg:bool) -> None: ...
    def SetUseTextActor3D(self, enable:bool) -> None: ...
    def SetViewAngleLODThreshold(self, _arg:float) -> None: ...
    def SetXAxesGridlinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetXAxesGridpolysProperty(self, __a:'vtkProperty') -> None: ...
    def SetXAxesInnerGridlinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetXAxesLabelProperty(self, __a:'vtkTextProperty') -> None: ...
    def SetXAxesLinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetXAxesTitleProperty(self, __a:'vtkTextProperty') -> None: ...
    def SetXAxisLabelVisibility(self, _arg:bool) -> None: ...
    def SetXAxisMinorTickVisibility(self, _arg:bool) -> None: ...
    @overload
    def SetXAxisRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetXAxisRange(self, _arg:Sequence[float]) -> None: ...
    def SetXAxisTickVisibility(self, _arg:bool) -> None: ...
    def SetXAxisVisibility(self, _arg:bool) -> None: ...
    def SetXLabelFormat(self, _arg:str) -> None: ...
    def SetXTitle(self, _arg:str) -> None: ...
    def SetXUnits(self, _arg:str) -> None: ...
    def SetYAxesGridlinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetYAxesGridpolysProperty(self, __a:'vtkProperty') -> None: ...
    def SetYAxesInnerGridlinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetYAxesLabelProperty(self, __a:'vtkTextProperty') -> None: ...
    def SetYAxesLinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetYAxesTitleProperty(self, __a:'vtkTextProperty') -> None: ...
    def SetYAxisLabelVisibility(self, _arg:bool) -> None: ...
    def SetYAxisMinorTickVisibility(self, _arg:bool) -> None: ...
    @overload
    def SetYAxisRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetYAxisRange(self, _arg:Sequence[float]) -> None: ...
    def SetYAxisTickVisibility(self, _arg:bool) -> None: ...
    def SetYAxisVisibility(self, _arg:bool) -> None: ...
    def SetYLabelFormat(self, _arg:str) -> None: ...
    def SetYTitle(self, _arg:str) -> None: ...
    def SetYUnits(self, _arg:str) -> None: ...
    def SetZAxesGridlinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetZAxesGridpolysProperty(self, __a:'vtkProperty') -> None: ...
    def SetZAxesInnerGridlinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetZAxesLabelProperty(self, __a:'vtkTextProperty') -> None: ...
    def SetZAxesLinesProperty(self, __a:'vtkProperty') -> None: ...
    def SetZAxesTitleProperty(self, __a:'vtkTextProperty') -> None: ...
    def SetZAxisLabelVisibility(self, _arg:bool) -> None: ...
    def SetZAxisMinorTickVisibility(self, _arg:bool) -> None: ...
    @overload
    def SetZAxisRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetZAxisRange(self, _arg:Sequence[float]) -> None: ...
    def SetZAxisTickVisibility(self, _arg:bool) -> None: ...
    def SetZAxisVisibility(self, _arg:bool) -> None: ...
    def SetZLabelFormat(self, _arg:str) -> None: ...
    def SetZTitle(self, _arg:str) -> None: ...
    def SetZUnits(self, _arg:str) -> None: ...
    def StickyAxesOff(self) -> None: ...
    def StickyAxesOn(self) -> None: ...
    def XAxisLabelVisibilityOff(self) -> None: ...
    def XAxisLabelVisibilityOn(self) -> None: ...
    def XAxisMinorTickVisibilityOff(self) -> None: ...
    def XAxisMinorTickVisibilityOn(self) -> None: ...
    def XAxisTickVisibilityOff(self) -> None: ...
    def XAxisTickVisibilityOn(self) -> None: ...
    def XAxisVisibilityOff(self) -> None: ...
    def XAxisVisibilityOn(self) -> None: ...
    def YAxisLabelVisibilityOff(self) -> None: ...
    def YAxisLabelVisibilityOn(self) -> None: ...
    def YAxisMinorTickVisibilityOff(self) -> None: ...
    def YAxisMinorTickVisibilityOn(self) -> None: ...
    def YAxisTickVisibilityOff(self) -> None: ...
    def YAxisTickVisibilityOn(self) -> None: ...
    def YAxisVisibilityOff(self) -> None: ...
    def YAxisVisibilityOn(self) -> None: ...
    def ZAxisLabelVisibilityOff(self) -> None: ...
    def ZAxisLabelVisibilityOn(self) -> None: ...
    def ZAxisMinorTickVisibilityOff(self) -> None: ...
    def ZAxisMinorTickVisibilityOn(self) -> None: ...
    def ZAxisTickVisibilityOff(self) -> None: ...
    def ZAxisTickVisibilityOn(self) -> None: ...
    def ZAxisVisibilityOff(self) -> None: ...
    def ZAxisVisibilityOn(self) -> None: ...

class vtkCubeAxesActor2D(vtkmodules.vtkRenderingCore.vtkActor2D):
    class FlyMode(int): ...
    VTK_FLY_CLOSEST_TRIAD:'FlyMode'
    VTK_FLY_NONE:'FlyMode'
    VTK_FLY_OUTER_EDGES:'FlyMode'
    axis_label_text_property:'getset_descriptor'
    axis_title_text_property:'getset_descriptor'
    bounds:'getset_descriptor'
    camera:'getset_descriptor'
    corner_offset:'getset_descriptor'
    fly_mode:'getset_descriptor'
    font_factor:'getset_descriptor'
    inertia:'getset_descriptor'
    input:'getset_descriptor'
    input_connection:'getset_descriptor'
    input_data:'getset_descriptor'
    label_format:'getset_descriptor'
    number_of_labels:'getset_descriptor'
    number_of_labels_max_value:'getset_descriptor'
    number_of_labels_min_value:'getset_descriptor'
    ranges:'getset_descriptor'
    scaling:'getset_descriptor'
    show_actual_bounds:'getset_descriptor'
    use_ranges:'getset_descriptor'
    view_prop:'getset_descriptor'
    x_axis_actor2d:'getset_descriptor'
    x_axis_visibility:'getset_descriptor'
    x_label:'getset_descriptor'
    x_origin:'getset_descriptor'
    y_axis_actor2d:'getset_descriptor'
    y_axis_visibility:'getset_descriptor'
    y_label:'getset_descriptor'
    y_origin:'getset_descriptor'
    z_axis_actor2d:'getset_descriptor'
    z_axis_visibility:'getset_descriptor'
    z_label:'getset_descriptor'
    z_origin:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAxisLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetAxisTitleTextProperty(self) -> 'vtkTextProperty': ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetCornerOffset(self) -> float: ...
    def GetFlyMode(self) -> int: ...
    def GetFlyModeMaxValue(self) -> int: ...
    def GetFlyModeMinValue(self) -> int: ...
    def GetFontFactor(self) -> float: ...
    def GetFontFactorMaxValue(self) -> float: ...
    def GetFontFactorMinValue(self) -> float: ...
    def GetInertia(self) -> int: ...
    def GetInertiaMaxValue(self) -> int: ...
    def GetInertiaMinValue(self) -> int: ...
    def GetInput(self) -> 'vtkDataSet': ...
    def GetLabelFormat(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    def GetNumberOfLabelsMaxValue(self) -> int: ...
    def GetNumberOfLabelsMinValue(self) -> int: ...
    @overload
    def GetRanges(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetRanges(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def GetRanges(self, ranges:MutableSequence[float]) -> None: ...
    def GetScaling(self) -> int: ...
    def GetShowActualBounds(self) -> int: ...
    def GetShowActualBoundsMaxValue(self) -> int: ...
    def GetShowActualBoundsMinValue(self) -> int: ...
    def GetUseRanges(self) -> int: ...
    def GetViewProp(self) -> 'vtkProp': ...
    def GetXAxisActor2D(self) -> 'vtkAxisActor2D': ...
    def GetXAxisVisibility(self) -> int: ...
    def GetXLabel(self) -> str: ...
    def GetYAxisActor2D(self) -> 'vtkAxisActor2D': ...
    def GetYAxisVisibility(self) -> int: ...
    def GetYLabel(self) -> str: ...
    def GetZAxisActor2D(self) -> 'vtkAxisActor2D': ...
    def GetZAxisVisibility(self) -> int: ...
    def GetZLabel(self) -> str: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCubeAxesActor2D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCubeAxesActor2D': ...
    def ScalingOff(self) -> None: ...
    def ScalingOn(self) -> None: ...
    def SetAxisLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetAxisTitleTextProperty(self, p:'vtkTextProperty') -> None: ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetCamera(self, __a:'vtkCamera') -> None: ...
    def SetCornerOffset(self, _arg:float) -> None: ...
    def SetFlyMode(self, _arg:int) -> None: ...
    def SetFlyModeToClosestTriad(self) -> None: ...
    def SetFlyModeToNone(self) -> None: ...
    def SetFlyModeToOuterEdges(self) -> None: ...
    def SetFontFactor(self, _arg:float) -> None: ...
    def SetInertia(self, _arg:int) -> None: ...
    def SetInputConnection(self, __a:'vtkAlgorithmOutput') -> None: ...
    def SetInputData(self, __a:'vtkDataSet') -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetNumberOfLabels(self, _arg:int) -> None: ...
    @overload
    def SetRanges(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetRanges(self, _arg:Sequence[float]) -> None: ...
    def SetScaling(self, _arg:int) -> None: ...
    def SetShowActualBounds(self, _arg:int) -> None: ...
    def SetUseRanges(self, _arg:int) -> None: ...
    def SetViewProp(self, prop:'vtkProp') -> None: ...
    def SetXAxisVisibility(self, _arg:int) -> None: ...
    def SetXLabel(self, _arg:str) -> None: ...
    def SetXOrigin(self, _arg:float) -> None: ...
    def SetYAxisVisibility(self, _arg:int) -> None: ...
    def SetYLabel(self, _arg:str) -> None: ...
    def SetYOrigin(self, _arg:float) -> None: ...
    def SetZAxisVisibility(self, _arg:int) -> None: ...
    def SetZLabel(self, _arg:str) -> None: ...
    def SetZOrigin(self, _arg:float) -> None: ...
    def ShallowCopy(self, actor:'vtkCubeAxesActor2D') -> None: ...
    def UseRangesOff(self) -> None: ...
    def UseRangesOn(self) -> None: ...
    def XAxisVisibilityOff(self) -> None: ...
    def XAxisVisibilityOn(self) -> None: ...
    def YAxisVisibilityOff(self) -> None: ...
    def YAxisVisibilityOn(self) -> None: ...
    def ZAxisVisibilityOff(self) -> None: ...
    def ZAxisVisibilityOn(self) -> None: ...

class vtkGraphAnnotationLayersFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    m_time:'getset_descriptor'
    min_hull_size_in_display:'getset_descriptor'
    min_hull_size_in_world:'getset_descriptor'
    outline:'getset_descriptor'
    renderer:'getset_descriptor'
    scale_factor:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphAnnotationLayersFilter': ...
    def OutlineOff(self) -> None: ...
    def OutlineOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphAnnotationLayersFilter': ...
    def SetHullShapeToBoundingRectangle(self) -> None: ...
    def SetHullShapeToConvexHull(self) -> None: ...
    def SetMinHullSizeInDisplay(self, size:int) -> None: ...
    def SetMinHullSizeInWorld(self, size:float) -> None: ...
    def SetOutline(self, b:bool) -> None: ...
    def SetRenderer(self, renderer:'vtkRenderer') -> None: ...
    def SetScaleFactor(self, scale:float) -> None: ...

class vtkLeaderActor2D(vtkmodules.vtkRenderingCore.vtkActor2D):
    VTK_ARROW_BOTH:int
    VTK_ARROW_FILLED:int
    VTK_ARROW_HOLLOW:int
    VTK_ARROW_NONE:int
    VTK_ARROW_OPEN:int
    VTK_ARROW_POINT1:int
    VTK_ARROW_POINT2:int
    angle:'getset_descriptor'
    arrow_length:'getset_descriptor'
    arrow_placement:'getset_descriptor'
    arrow_style:'getset_descriptor'
    arrow_width:'getset_descriptor'
    auto_label:'getset_descriptor'
    label:'getset_descriptor'
    label_factor:'getset_descriptor'
    label_format:'getset_descriptor'
    label_text_property:'getset_descriptor'
    length:'getset_descriptor'
    maximum_arrow_size:'getset_descriptor'
    minimum_arrow_size:'getset_descriptor'
    radius:'getset_descriptor'
    use_font_size_from_property:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutoLabelOff(self) -> None: ...
    def AutoLabelOn(self) -> None: ...
    def GetAngle(self) -> float: ...
    def GetArrowLength(self) -> float: ...
    def GetArrowLengthMaxValue(self) -> float: ...
    def GetArrowLengthMinValue(self) -> float: ...
    def GetArrowPlacement(self) -> int: ...
    def GetArrowPlacementMaxValue(self) -> int: ...
    def GetArrowPlacementMinValue(self) -> int: ...
    def GetArrowStyle(self) -> int: ...
    def GetArrowStyleMaxValue(self) -> int: ...
    def GetArrowStyleMinValue(self) -> int: ...
    def GetArrowWidth(self) -> float: ...
    def GetArrowWidthMaxValue(self) -> float: ...
    def GetArrowWidthMinValue(self) -> float: ...
    def GetAutoLabel(self) -> int: ...
    def GetLabel(self) -> str: ...
    def GetLabelFactor(self) -> float: ...
    def GetLabelFactorMaxValue(self) -> float: ...
    def GetLabelFactorMinValue(self) -> float: ...
    def GetLabelFormat(self) -> str: ...
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetLength(self) -> float: ...
    def GetMaximumArrowSize(self) -> float: ...
    def GetMaximumArrowSizeMaxValue(self) -> float: ...
    def GetMaximumArrowSizeMinValue(self) -> float: ...
    def GetMinimumArrowSize(self) -> float: ...
    def GetMinimumArrowSizeMaxValue(self) -> float: ...
    def GetMinimumArrowSizeMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRadius(self) -> float: ...
    def GetUseFontSizeFromProperty(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLeaderActor2D': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLeaderActor2D': ...
    def SetArrowLength(self, _arg:float) -> None: ...
    def SetArrowPlacement(self, _arg:int) -> None: ...
    def SetArrowPlacementToBoth(self) -> None: ...
    def SetArrowPlacementToNone(self) -> None: ...
    def SetArrowPlacementToPoint1(self) -> None: ...
    def SetArrowPlacementToPoint2(self) -> None: ...
    def SetArrowStyle(self, _arg:int) -> None: ...
    def SetArrowStyleToFilled(self) -> None: ...
    def SetArrowStyleToHollow(self) -> None: ...
    def SetArrowStyleToOpen(self) -> None: ...
    def SetArrowWidth(self, _arg:float) -> None: ...
    def SetAutoLabel(self, _arg:int) -> None: ...
    def SetLabel(self, _arg:str) -> None: ...
    def SetLabelFactor(self, _arg:float) -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetMaximumArrowSize(self, _arg:float) -> None: ...
    def SetMinimumArrowSize(self, _arg:float) -> None: ...
    def SetRadius(self, _arg:float) -> None: ...
    def SetUseFontSizeFromProperty(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def UseFontSizeFromPropertyOff(self) -> None: ...
    def UseFontSizeFromPropertyOn(self) -> None: ...

class vtkLegendBoxActor(vtkmodules.vtkRenderingCore.vtkActor2D):
    background_color:'getset_descriptor'
    background_opacity:'getset_descriptor'
    border:'getset_descriptor'
    box:'getset_descriptor'
    box_property:'getset_descriptor'
    entry_text_property:'getset_descriptor'
    lock_border:'getset_descriptor'
    number_of_entries:'getset_descriptor'
    padding:'getset_descriptor'
    scalar_visibility:'getset_descriptor'
    use_background:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BorderOff(self) -> None: ...
    def BorderOn(self) -> None: ...
    def BoxOff(self) -> None: ...
    def BoxOn(self) -> None: ...
    def GetBackgroundColor(self) -> Tuple[float, float, float]: ...
    def GetBackgroundOpacity(self) -> float: ...
    def GetBackgroundOpacityMaxValue(self) -> float: ...
    def GetBackgroundOpacityMinValue(self) -> float: ...
    def GetBorder(self) -> int: ...
    def GetBox(self) -> int: ...
    def GetBoxProperty(self) -> 'vtkProperty2D': ...
    def GetEntryColor(self, i:int) -> Tuple[float, float, float]: ...
    def GetEntryIcon(self, i:int) -> 'vtkImageData': ...
    def GetEntryString(self, i:int) -> str: ...
    def GetEntrySymbol(self, i:int) -> 'vtkPolyData': ...
    def GetEntryTextProperty(self) -> 'vtkTextProperty': ...
    def GetLockBorder(self) -> int: ...
    def GetNumberOfEntries(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPadding(self) -> int: ...
    def GetPaddingMaxValue(self) -> int: ...
    def GetPaddingMinValue(self) -> int: ...
    def GetScalarVisibility(self) -> int: ...
    def GetUseBackground(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LockBorderOff(self) -> None: ...
    def LockBorderOn(self) -> None: ...
    def NewInstance(self) -> 'vtkLegendBoxActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLegendBoxActor': ...
    def ScalarVisibilityOff(self) -> None: ...
    def ScalarVisibilityOn(self) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg:Sequence[float]) -> None: ...
    def SetBackgroundOpacity(self, _arg:float) -> None: ...
    def SetBorder(self, _arg:int) -> None: ...
    def SetBox(self, _arg:int) -> None: ...
    @overload
    def SetEntry(self, i:int, symbol:'vtkPolyData', string:str, color:MutableSequence[float]) -> None: ...
    @overload
    def SetEntry(self, i:int, symbol:'vtkImageData', string:str, color:MutableSequence[float]) -> None: ...
    @overload
    def SetEntry(self, i:int, symbol:'vtkPolyData', icon:'vtkImageData', string:str, color:MutableSequence[float]) -> None: ...
    @overload
    def SetEntryColor(self, i:int, color:MutableSequence[float]) -> None: ...
    @overload
    def SetEntryColor(self, i:int, r:float, g:float, b:float) -> None: ...
    def SetEntryIcon(self, i:int, icon:'vtkImageData') -> None: ...
    def SetEntryString(self, i:int, string:str) -> None: ...
    def SetEntrySymbol(self, i:int, symbol:'vtkPolyData') -> None: ...
    def SetEntryTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetLockBorder(self, _arg:int) -> None: ...
    def SetNumberOfEntries(self, num:int) -> None: ...
    def SetPadding(self, _arg:int) -> None: ...
    def SetScalarVisibility(self, _arg:int) -> None: ...
    def SetUseBackground(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def UseBackgroundOff(self) -> None: ...
    def UseBackgroundOn(self) -> None: ...

class vtkLegendScaleActor(vtkmodules.vtkRenderingCore.vtkProp):
    class AttributeLocation(int): ...
    COORDINATES:'AttributeLocation'
    DISTANCE:'AttributeLocation'
    XY_COORDINATES:'AttributeLocation'
    adjust_labels:'getset_descriptor'
    axes_property:'getset_descriptor'
    axes_text_property:'getset_descriptor'
    bottom_axis:'getset_descriptor'
    bottom_axis_visibility:'getset_descriptor'
    bottom_border_offset:'getset_descriptor'
    corner_offset_factor:'getset_descriptor'
    grid_visibility:'getset_descriptor'
    label_mode:'getset_descriptor'
    left_axis:'getset_descriptor'
    left_axis_visibility:'getset_descriptor'
    left_border_offset:'getset_descriptor'
    legend_label_property:'getset_descriptor'
    legend_title_property:'getset_descriptor'
    legend_visibility:'getset_descriptor'
    notation:'getset_descriptor'
    number_of_horizontal_labels:'getset_descriptor'
    number_of_vertical_labels:'getset_descriptor'
    origin:'getset_descriptor'
    precision:'getset_descriptor'
    right_axis:'getset_descriptor'
    right_axis_visibility:'getset_descriptor'
    right_border_offset:'getset_descriptor'
    snap_to_grid:'getset_descriptor'
    top_axis:'getset_descriptor'
    top_axis_visibility:'getset_descriptor'
    top_border_offset:'getset_descriptor'
    use_font_size_from_property:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AllAnnotationsOff(self) -> None: ...
    def AllAnnotationsOn(self) -> None: ...
    def AllAxesOff(self) -> None: ...
    def AllAxesOn(self) -> None: ...
    def BottomAxisVisibilityOff(self) -> None: ...
    def BottomAxisVisibilityOn(self) -> None: ...
    def BuildRepresentation(self, viewport:'vtkViewport') -> None: ...
    def GetActors2D(self, __a:'vtkPropCollection') -> None: ...
    def GetAxesProperty(self) -> 'vtkProperty2D': ...
    def GetBottomAxis(self) -> 'vtkAxisActor2D': ...
    def GetBottomAxisVisibility(self) -> int: ...
    def GetBottomBorderOffset(self) -> int: ...
    def GetBottomBorderOffsetMaxValue(self) -> int: ...
    def GetBottomBorderOffsetMinValue(self) -> int: ...
    def GetCornerOffsetFactor(self) -> float: ...
    def GetCornerOffsetFactorMaxValue(self) -> float: ...
    def GetCornerOffsetFactorMinValue(self) -> float: ...
    def GetGridVisibility(self) -> bool: ...
    def GetLabelMode(self) -> int: ...
    def GetLabelModeMaxValue(self) -> int: ...
    def GetLabelModeMinValue(self) -> int: ...
    def GetLeftAxis(self) -> 'vtkAxisActor2D': ...
    def GetLeftAxisVisibility(self) -> int: ...
    def GetLeftBorderOffset(self) -> int: ...
    def GetLeftBorderOffsetMaxValue(self) -> int: ...
    def GetLeftBorderOffsetMinValue(self) -> int: ...
    def GetLegendLabelProperty(self) -> 'vtkTextProperty': ...
    def GetLegendTitleProperty(self) -> 'vtkTextProperty': ...
    def GetLegendVisibility(self) -> int: ...
    def GetNotation(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfHorizontalLabels(self) -> int: ...
    def GetNumberOfVerticalLabels(self) -> int: ...
    def GetOrigin(self) -> Tuple[float, float, float]: ...
    def GetPrecision(self) -> int: ...
    def GetRightAxis(self) -> 'vtkAxisActor2D': ...
    def GetRightAxisVisibility(self) -> int: ...
    def GetRightBorderOffset(self) -> int: ...
    def GetRightBorderOffsetMaxValue(self) -> int: ...
    def GetRightBorderOffsetMinValue(self) -> int: ...
    def GetTopAxis(self) -> 'vtkAxisActor2D': ...
    def GetTopAxisVisibility(self) -> int: ...
    def GetTopBorderOffset(self) -> int: ...
    def GetTopBorderOffsetMaxValue(self) -> int: ...
    def GetTopBorderOffsetMinValue(self) -> int: ...
    def GridVisibilityOff(self) -> None: ...
    def GridVisibilityOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LeftAxisVisibilityOff(self) -> None: ...
    def LeftAxisVisibilityOn(self) -> None: ...
    def LegendVisibilityOff(self) -> None: ...
    def LegendVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkLegendScaleActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RightAxisVisibilityOff(self) -> None: ...
    def RightAxisVisibilityOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLegendScaleActor': ...
    def SetAdjustLabels(self, adjust:bool) -> None: ...
    def SetAxesProperty(self, property:'vtkProperty2D') -> None: ...
    def SetAxesTextProperty(self, property:'vtkTextProperty') -> None: ...
    def SetBottomAxisVisibility(self, _arg:int) -> None: ...
    def SetBottomBorderOffset(self, _arg:int) -> None: ...
    def SetCornerOffsetFactor(self, _arg:float) -> None: ...
    def SetGridVisibility(self, _arg:bool) -> None: ...
    def SetLabelMode(self, _arg:int) -> None: ...
    def SetLabelModeToCoordinates(self) -> None: ...
    def SetLabelModeToDistance(self) -> None: ...
    def SetLabelModeToXYCoordinates(self) -> None: ...
    def SetLeftAxisVisibility(self, _arg:int) -> None: ...
    def SetLeftBorderOffset(self, _arg:int) -> None: ...
    def SetLegendVisibility(self, _arg:int) -> None: ...
    def SetNotation(self, notation:int) -> None: ...
    def SetNumberOfHorizontalLabels(self, val:int) -> None: ...
    def SetNumberOfVerticalLabels(self, val:int) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetPrecision(self, val:int) -> None: ...
    def SetRightAxisVisibility(self, _arg:int) -> None: ...
    def SetRightBorderOffset(self, _arg:int) -> None: ...
    def SetSnapToGrid(self, snap:bool) -> None: ...
    def SetTopAxisVisibility(self, _arg:int) -> None: ...
    def SetTopBorderOffset(self, _arg:int) -> None: ...
    def SetUseFontSizeFromProperty(self, sizeFromProp:bool) -> None: ...
    def TopAxisVisibilityOff(self) -> None: ...
    def TopAxisVisibilityOn(self) -> None: ...

class vtkParallelCoordinatesActor(vtkmodules.vtkRenderingCore.vtkActor2D):
    independent_variables:'getset_descriptor'
    input:'getset_descriptor'
    input_connection:'getset_descriptor'
    input_data:'getset_descriptor'
    label_format:'getset_descriptor'
    label_text_property:'getset_descriptor'
    number_of_labels:'getset_descriptor'
    number_of_labels_max_value:'getset_descriptor'
    number_of_labels_min_value:'getset_descriptor'
    title:'getset_descriptor'
    title_text_property:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetIndependentVariables(self) -> int: ...
    def GetIndependentVariablesMaxValue(self) -> int: ...
    def GetIndependentVariablesMinValue(self) -> int: ...
    def GetInput(self) -> 'vtkDataObject': ...
    def GetLabelFormat(self) -> str: ...
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    def GetNumberOfLabelsMaxValue(self) -> int: ...
    def GetNumberOfLabelsMinValue(self) -> int: ...
    def GetTitle(self) -> str: ...
    def GetTitleTextProperty(self) -> 'vtkTextProperty': ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkParallelCoordinatesActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkParallelCoordinatesActor': ...
    def SetIndependentVariables(self, _arg:int) -> None: ...
    def SetIndependentVariablesToColumns(self) -> None: ...
    def SetIndependentVariablesToRows(self) -> None: ...
    def SetInputConnection(self, __a:'vtkAlgorithmOutput') -> None: ...
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetNumberOfLabels(self, _arg:int) -> None: ...
    def SetTitle(self, _arg:str) -> None: ...
    def SetTitleTextProperty(self, p:'vtkTextProperty') -> None: ...

class vtkPieChartActor(vtkmodules.vtkRenderingCore.vtkActor2D):
    input:'getset_descriptor'
    input_connection:'getset_descriptor'
    input_data:'getset_descriptor'
    label_text_property:'getset_descriptor'
    label_visibility:'getset_descriptor'
    legend_actor:'getset_descriptor'
    legend_visibility:'getset_descriptor'
    title:'getset_descriptor'
    title_text_property:'getset_descriptor'
    title_visibility:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetInput(self) -> 'vtkDataObject': ...
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetLabelVisibility(self) -> int: ...
    def GetLegendActor(self) -> 'vtkLegendBoxActor': ...
    def GetLegendVisibility(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPieceColor(self, i:int) -> Pointer: ...
    def GetPieceLabel(self, i:int) -> str: ...
    def GetTitle(self) -> str: ...
    def GetTitleTextProperty(self) -> 'vtkTextProperty': ...
    def GetTitleVisibility(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def LegendVisibilityOff(self) -> None: ...
    def LegendVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkPieChartActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPieChartActor': ...
    def SetInputConnection(self, __a:'vtkAlgorithmOutput') -> None: ...
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    def SetLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetLabelVisibility(self, _arg:int) -> None: ...
    def SetLegendVisibility(self, _arg:int) -> None: ...
    @overload
    def SetPieceColor(self, i:int, r:float, g:float, b:float) -> None: ...
    @overload
    def SetPieceColor(self, i:int, color:Sequence[float]) -> None: ...
    def SetPieceLabel(self, i:int, __b:str) -> None: ...
    def SetTitle(self, _arg:str) -> None: ...
    def SetTitleTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetTitleVisibility(self, _arg:int) -> None: ...
    def TitleVisibilityOff(self) -> None: ...
    def TitleVisibilityOn(self) -> None: ...

class vtkPolarAxesActor(vtkmodules.vtkRenderingCore.vtkActor):
    class ExponentLocation(int): ...
    class TitleLocation(int): ...
    VTK_EXPONENT_BOTTOM:'ExponentLocation'
    VTK_EXPONENT_EXTERN:'ExponentLocation'
    VTK_EXPONENT_LABELS:'ExponentLocation'
    VTK_TITLE_BOTTOM:'TitleLocation'
    VTK_TITLE_EXTERN:'TitleLocation'
    arc_major_tick_size:'getset_descriptor'
    arc_major_tick_thickness:'getset_descriptor'
    arc_minor_tick_visibility:'getset_descriptor'
    arc_tick_matches_radial_axes:'getset_descriptor'
    arc_tick_ratio_size:'getset_descriptor'
    arc_tick_ratio_thickness:'getset_descriptor'
    arc_tick_visibility:'getset_descriptor'
    arc_ticks_origin_to_polar_axis:'getset_descriptor'
    auto_subdivide_polar_axis:'getset_descriptor'
    axis_minor_tick_visibility:'getset_descriptor'
    axis_tick_matches_polar_axes:'getset_descriptor'
    axis_tick_visibility:'getset_descriptor'
    bounds:'getset_descriptor'
    camera:'getset_descriptor'
    delta_angle_major:'getset_descriptor'
    delta_angle_minor:'getset_descriptor'
    delta_range_major:'getset_descriptor'
    delta_range_minor:'getset_descriptor'
    distance_lod_threshold:'getset_descriptor'
    draw_polar_arcs_gridlines:'getset_descriptor'
    draw_radial_gridlines:'getset_descriptor'
    enable_distance_lod:'getset_descriptor'
    enable_view_angle_lod:'getset_descriptor'
    exponent_location:'getset_descriptor'
    last_axis_tick_ratio_size:'getset_descriptor'
    last_axis_tick_ratio_thickness:'getset_descriptor'
    last_radial_axis_major_tick_size:'getset_descriptor'
    last_radial_axis_major_tick_thickness:'getset_descriptor'
    last_radial_axis_property:'getset_descriptor'
    last_radial_axis_text_property:'getset_descriptor'
    log:'getset_descriptor'
    maximum_angle:'getset_descriptor'
    maximum_radius:'getset_descriptor'
    minimum_angle:'getset_descriptor'
    minimum_radius:'getset_descriptor'
    number_of_polar_axis_ticks:'getset_descriptor'
    polar_arc_resolution_per_degree:'getset_descriptor'
    polar_arcs_property:'getset_descriptor'
    polar_arcs_visibility:'getset_descriptor'
    polar_axis_label_text_property:'getset_descriptor'
    polar_axis_major_tick_size:'getset_descriptor'
    polar_axis_major_tick_thickness:'getset_descriptor'
    polar_axis_property:'getset_descriptor'
    polar_axis_tick_ratio_size:'getset_descriptor'
    polar_axis_tick_ratio_thickness:'getset_descriptor'
    polar_axis_title:'getset_descriptor'
    polar_axis_title_location:'getset_descriptor'
    polar_axis_title_text_property:'getset_descriptor'
    polar_axis_visibility:'getset_descriptor'
    polar_exponent_offset:'getset_descriptor'
    polar_label_format:'getset_descriptor'
    polar_label_offset:'getset_descriptor'
    polar_label_visibility:'getset_descriptor'
    polar_tick_visibility:'getset_descriptor'
    polar_title_offset:'getset_descriptor'
    polar_title_visibility:'getset_descriptor'
    pole:'getset_descriptor'
    radial_angle_format:'getset_descriptor'
    radial_axes_origin_to_polar_axis:'getset_descriptor'
    radial_axes_visibility:'getset_descriptor'
    radial_axis_title_location:'getset_descriptor'
    radial_title_offset:'getset_descriptor'
    radial_title_visibility:'getset_descriptor'
    radial_units:'getset_descriptor'
    range:'getset_descriptor'
    ratio:'getset_descriptor'
    requested_delta_angle_radial_axes:'getset_descriptor'
    requested_delta_range_polar_axes:'getset_descriptor'
    requested_number_of_polar_axes:'getset_descriptor'
    requested_number_of_radial_axes:'getset_descriptor'
    screen_size:'getset_descriptor'
    secondary_polar_arcs_property:'getset_descriptor'
    secondary_radial_axes_property:'getset_descriptor'
    secondary_radial_axes_text_property:'getset_descriptor'
    smallest_visible_polar_angle:'getset_descriptor'
    tick_location:'getset_descriptor'
    tick_ratio_radius_size:'getset_descriptor'
    use2d_mode:'getset_descriptor'
    view_angle_lod_threshold:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ArcMinorTickVisibilityOff(self) -> None: ...
    def ArcMinorTickVisibilityOn(self) -> None: ...
    def ArcTickMatchesRadialAxesOff(self) -> None: ...
    def ArcTickMatchesRadialAxesOn(self) -> None: ...
    def ArcTickVisibilityOff(self) -> None: ...
    def ArcTickVisibilityOn(self) -> None: ...
    def ArcTicksOriginToPolarAxisOff(self) -> None: ...
    def ArcTicksOriginToPolarAxisOn(self) -> None: ...
    def AutoSubdividePolarAxisOff(self) -> None: ...
    def AutoSubdividePolarAxisOn(self) -> None: ...
    def AxisMinorTickVisibilityOff(self) -> None: ...
    def AxisMinorTickVisibilityOn(self) -> None: ...
    def AxisTickMatchesPolarAxesOff(self) -> None: ...
    def AxisTickMatchesPolarAxesOn(self) -> None: ...
    def AxisTickVisibilityOff(self) -> None: ...
    def AxisTickVisibilityOn(self) -> None: ...
    def DrawPolarArcsGridlinesOff(self) -> None: ...
    def DrawPolarArcsGridlinesOn(self) -> None: ...
    def DrawRadialGridlinesOff(self) -> None: ...
    def DrawRadialGridlinesOn(self) -> None: ...
    def GetArcMajorTickSize(self) -> float: ...
    def GetArcMajorTickThickness(self) -> float: ...
    def GetArcMinorTickVisibility(self) -> bool: ...
    def GetArcTickMatchesRadialAxes(self) -> bool: ...
    def GetArcTickRatioSize(self) -> float: ...
    def GetArcTickRatioThickness(self) -> float: ...
    def GetArcTickVisibility(self) -> bool: ...
    def GetArcTicksOriginToPolarAxis(self) -> bool: ...
    def GetAutoSubdividePolarAxis(self) -> bool: ...
    def GetAxisMinorTickVisibility(self) -> bool: ...
    def GetAxisTickMatchesPolarAxes(self) -> bool: ...
    def GetAxisTickVisibility(self) -> bool: ...
    @overload
    def GetBounds(self) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def GetBounds(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def GetBounds(self, bounds:MutableSequence[float]) -> None: ...
    def GetCamera(self) -> 'vtkCamera': ...
    def GetDeltaAngleMajor(self) -> float: ...
    def GetDeltaAngleMinor(self) -> float: ...
    def GetDeltaRangeMajor(self) -> float: ...
    def GetDeltaRangeMinor(self) -> float: ...
    def GetDistanceLODThreshold(self) -> float: ...
    def GetDistanceLODThresholdMaxValue(self) -> float: ...
    def GetDistanceLODThresholdMinValue(self) -> float: ...
    def GetDrawPolarArcsGridlines(self) -> bool: ...
    def GetDrawRadialGridlines(self) -> bool: ...
    def GetEnableDistanceLOD(self) -> bool: ...
    def GetEnableViewAngleLOD(self) -> bool: ...
    def GetExponentLocation(self) -> int: ...
    def GetExponentLocationMaxValue(self) -> int: ...
    def GetExponentLocationMinValue(self) -> int: ...
    def GetLastAxisTickRatioSize(self) -> float: ...
    def GetLastAxisTickRatioThickness(self) -> float: ...
    def GetLastRadialAxisMajorTickSize(self) -> float: ...
    def GetLastRadialAxisMajorTickThickness(self) -> float: ...
    def GetLastRadialAxisProperty(self) -> 'vtkProperty': ...
    def GetLastRadialAxisTextProperty(self) -> 'vtkTextProperty': ...
    def GetLog(self) -> bool: ...
    def GetMaximumAngle(self) -> float: ...
    def GetMaximumRadius(self) -> float: ...
    def GetMinimumAngle(self) -> float: ...
    def GetMinimumRadius(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPolarAxisTicks(self) -> int: ...
    def GetPolarArcResolutionPerDegree(self) -> float: ...
    def GetPolarArcResolutionPerDegreeMaxValue(self) -> float: ...
    def GetPolarArcResolutionPerDegreeMinValue(self) -> float: ...
    def GetPolarArcsProperty(self) -> 'vtkProperty': ...
    def GetPolarArcsVisibility(self) -> bool: ...
    def GetPolarAxisLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetPolarAxisMajorTickSize(self) -> float: ...
    def GetPolarAxisMajorTickThickness(self) -> float: ...
    def GetPolarAxisProperty(self) -> 'vtkProperty': ...
    def GetPolarAxisTickRatioSize(self) -> float: ...
    def GetPolarAxisTickRatioThickness(self) -> float: ...
    def GetPolarAxisTitle(self) -> str: ...
    def GetPolarAxisTitleLocation(self) -> int: ...
    def GetPolarAxisTitleLocationMaxValue(self) -> int: ...
    def GetPolarAxisTitleLocationMinValue(self) -> int: ...
    def GetPolarAxisTitleTextProperty(self) -> 'vtkTextProperty': ...
    def GetPolarAxisVisibility(self) -> bool: ...
    def GetPolarExponentOffset(self) -> float: ...
    def GetPolarLabelFormat(self) -> str: ...
    def GetPolarLabelOffset(self) -> float: ...
    def GetPolarLabelVisibility(self) -> bool: ...
    def GetPolarTickVisibility(self) -> bool: ...
    def GetPolarTitleOffset(self) -> Tuple[float, float]: ...
    def GetPolarTitleVisibility(self) -> bool: ...
    def GetPole(self) -> Tuple[float, float, float]: ...
    def GetRadialAngleFormat(self) -> str: ...
    def GetRadialAxesOriginToPolarAxis(self) -> bool: ...
    def GetRadialAxesVisibility(self) -> bool: ...
    def GetRadialAxisTitleLocation(self) -> int: ...
    def GetRadialAxisTitleLocationMaxValue(self) -> int: ...
    def GetRadialAxisTitleLocationMinValue(self) -> int: ...
    def GetRadialTitleOffset(self) -> Tuple[float, float]: ...
    def GetRadialTitleVisibility(self) -> bool: ...
    def GetRadialUnits(self) -> bool: ...
    def GetRange(self) -> Tuple[float, float]: ...
    def GetRatio(self) -> float: ...
    def GetRatioMaxValue(self) -> float: ...
    def GetRatioMinValue(self) -> float: ...
    def GetRequestedDeltaAngleRadialAxes(self) -> float: ...
    def GetRequestedDeltaRangePolarAxes(self) -> float: ...
    def GetRequestedNumberOfPolarAxes(self) -> int: ...
    def GetRequestedNumberOfPolarAxesMaxValue(self) -> int: ...
    def GetRequestedNumberOfPolarAxesMinValue(self) -> int: ...
    def GetRequestedNumberOfRadialAxes(self) -> int: ...
    def GetRequestedNumberOfRadialAxesMaxValue(self) -> int: ...
    def GetRequestedNumberOfRadialAxesMinValue(self) -> int: ...
    def GetScreenSize(self) -> float: ...
    def GetSecondaryPolarArcsProperty(self) -> 'vtkProperty': ...
    def GetSecondaryRadialAxesProperty(self) -> 'vtkProperty': ...
    def GetSecondaryRadialAxesTextProperty(self) -> 'vtkTextProperty': ...
    def GetSmallestVisiblePolarAngle(self) -> float: ...
    def GetSmallestVisiblePolarAngleMaxValue(self) -> float: ...
    def GetSmallestVisiblePolarAngleMinValue(self) -> float: ...
    def GetTickLocation(self) -> int: ...
    def GetTickLocationMaxValue(self) -> int: ...
    def GetTickLocationMinValue(self) -> int: ...
    def GetTickRatioRadiusSize(self) -> float: ...
    def GetUse2DMode(self) -> bool: ...
    def GetViewAngleLODThreshold(self) -> float: ...
    def GetViewAngleLODThresholdMaxValue(self) -> float: ...
    def GetViewAngleLODThresholdMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LogOff(self) -> None: ...
    def LogOn(self) -> None: ...
    def NewInstance(self) -> 'vtkPolarAxesActor': ...
    def PolarArcsVisibilityOff(self) -> None: ...
    def PolarArcsVisibilityOn(self) -> None: ...
    def PolarAxisVisibilityOff(self) -> None: ...
    def PolarAxisVisibilityOn(self) -> None: ...
    def PolarLabelVisibilityOff(self) -> None: ...
    def PolarLabelVisibilityOn(self) -> None: ...
    def PolarTickVisibilityOff(self) -> None: ...
    def PolarTickVisibilityOn(self) -> None: ...
    def PolarTitleVisibilityOff(self) -> None: ...
    def PolarTitleVisibilityOn(self) -> None: ...
    def RadialAxesOriginToPolarAxisOff(self) -> None: ...
    def RadialAxesOriginToPolarAxisOn(self) -> None: ...
    def RadialAxesVisibilityOff(self) -> None: ...
    def RadialAxesVisibilityOn(self) -> None: ...
    def RadialTitleVisibilityOff(self) -> None: ...
    def RadialTitleVisibilityOn(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolarAxesActor': ...
    def SetArcMajorTickSize(self, _arg:float) -> None: ...
    def SetArcMajorTickThickness(self, _arg:float) -> None: ...
    def SetArcMinorTickVisibility(self, _arg:bool) -> None: ...
    def SetArcTickMatchesRadialAxes(self, _arg:bool) -> None: ...
    def SetArcTickRatioSize(self, _arg:float) -> None: ...
    def SetArcTickRatioThickness(self, _arg:float) -> None: ...
    def SetArcTickVisibility(self, _arg:bool) -> None: ...
    def SetArcTicksOriginToPolarAxis(self, _arg:bool) -> None: ...
    def SetAutoSubdividePolarAxis(self, _arg:bool) -> None: ...
    def SetAxisMinorTickVisibility(self, _arg:bool) -> None: ...
    def SetAxisTickMatchesPolarAxes(self, _arg:bool) -> None: ...
    def SetAxisTickVisibility(self, _arg:bool) -> None: ...
    @overload
    def SetBounds(self, _arg1:float, _arg2:float, _arg3:float, _arg4:float, _arg5:float, _arg6:float) -> None: ...
    @overload
    def SetBounds(self, _arg:Sequence[float]) -> None: ...
    def SetCamera(self, __a:'vtkCamera') -> None: ...
    def SetDeltaAngleMajor(self, _arg:float) -> None: ...
    def SetDeltaAngleMinor(self, _arg:float) -> None: ...
    def SetDeltaRangeMajor(self, _arg:float) -> None: ...
    def SetDeltaRangeMinor(self, _arg:float) -> None: ...
    def SetDistanceLODThreshold(self, _arg:float) -> None: ...
    def SetDrawPolarArcsGridlines(self, _arg:bool) -> None: ...
    def SetDrawRadialGridlines(self, _arg:bool) -> None: ...
    def SetEnableDistanceLOD(self, _arg:bool) -> None: ...
    def SetEnableViewAngleLOD(self, _arg:bool) -> None: ...
    def SetExponentLocation(self, _arg:int) -> None: ...
    def SetLastAxisTickRatioSize(self, _arg:float) -> None: ...
    def SetLastAxisTickRatioThickness(self, _arg:float) -> None: ...
    def SetLastRadialAxisMajorTickSize(self, _arg:float) -> None: ...
    def SetLastRadialAxisMajorTickThickness(self, _arg:float) -> None: ...
    def SetLastRadialAxisProperty(self, p:'vtkProperty') -> None: ...
    def SetLastRadialAxisTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetLog(self, _arg:bool) -> None: ...
    def SetMaximumAngle(self, __a:float) -> None: ...
    def SetMaximumRadius(self, __a:float) -> None: ...
    def SetMinimumAngle(self, __a:float) -> None: ...
    def SetMinimumRadius(self, __a:float) -> None: ...
    def SetNumberOfPolarAxisTicks(self, __a:int) -> None: ...
    def SetPolarArcResolutionPerDegree(self, _arg:float) -> None: ...
    def SetPolarArcsProperty(self, p:'vtkProperty') -> None: ...
    def SetPolarArcsVisibility(self, _arg:bool) -> None: ...
    def SetPolarAxisLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetPolarAxisMajorTickSize(self, _arg:float) -> None: ...
    def SetPolarAxisMajorTickThickness(self, _arg:float) -> None: ...
    def SetPolarAxisProperty(self, __a:'vtkProperty') -> None: ...
    def SetPolarAxisTickRatioSize(self, _arg:float) -> None: ...
    def SetPolarAxisTickRatioThickness(self, _arg:float) -> None: ...
    def SetPolarAxisTitle(self, _arg:str) -> None: ...
    def SetPolarAxisTitleLocation(self, _arg:int) -> None: ...
    def SetPolarAxisTitleTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetPolarAxisVisibility(self, _arg:bool) -> None: ...
    def SetPolarExponentOffset(self, _arg:float) -> None: ...
    def SetPolarLabelFormat(self, _arg:str) -> None: ...
    def SetPolarLabelOffset(self, _arg:float) -> None: ...
    def SetPolarLabelVisibility(self, _arg:bool) -> None: ...
    def SetPolarTickVisibility(self, _arg:bool) -> None: ...
    @overload
    def SetPolarTitleOffset(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPolarTitleOffset(self, _arg:Sequence[float]) -> None: ...
    def SetPolarTitleVisibility(self, _arg:bool) -> None: ...
    @overload
    def SetPole(self, __a:MutableSequence[float]) -> None: ...
    @overload
    def SetPole(self, __a:float, __b:float, __c:float) -> None: ...
    def SetRadialAngleFormat(self, _arg:str) -> None: ...
    def SetRadialAxesOriginToPolarAxis(self, _arg:bool) -> None: ...
    def SetRadialAxesVisibility(self, _arg:bool) -> None: ...
    def SetRadialAxisTitleLocation(self, _arg:int) -> None: ...
    @overload
    def SetRadialTitleOffset(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetRadialTitleOffset(self, _arg:Sequence[float]) -> None: ...
    def SetRadialTitleVisibility(self, _arg:bool) -> None: ...
    def SetRadialUnits(self, _arg:bool) -> None: ...
    @overload
    def SetRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetRange(self, _arg:Sequence[float]) -> None: ...
    def SetRatio(self, _arg:float) -> None: ...
    def SetRequestedDeltaAngleRadialAxes(self, _arg:float) -> None: ...
    def SetRequestedDeltaRangePolarAxes(self, _arg:float) -> None: ...
    def SetRequestedNumberOfPolarAxes(self, _arg:int) -> None: ...
    def SetRequestedNumberOfRadialAxes(self, _arg:int) -> None: ...
    def SetScreenSize(self, _arg:float) -> None: ...
    def SetSecondaryPolarArcsProperty(self, p:'vtkProperty') -> None: ...
    def SetSecondaryRadialAxesProperty(self, p:'vtkProperty') -> None: ...
    def SetSecondaryRadialAxesTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetSmallestVisiblePolarAngle(self, _arg:float) -> None: ...
    def SetTickLocation(self, _arg:int) -> None: ...
    def SetTickRatioRadiusSize(self, _arg:float) -> None: ...
    def SetUse2DMode(self, enable:bool) -> None: ...
    def SetViewAngleLODThreshold(self, _arg:float) -> None: ...

class vtkPolarAxesActor2D(vtkmodules.vtkRenderingCore.vtkActor2D):
    axes_length:'getset_descriptor'
    axes_text_property:'getset_descriptor'
    end_angle:'getset_descriptor'
    number_of_axes:'getset_descriptor'
    number_of_axes_ticks:'getset_descriptor'
    origin:'getset_descriptor'
    start_angle:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetActors2D(self, pc:'vtkPropCollection') -> None: ...
    def GetAxesLength(self) -> float: ...
    def GetAxesTextProperty(self) -> 'vtkTextProperty': ...
    def GetEndAngle(self) -> float: ...
    def GetNumberOfAxes(self) -> int: ...
    def GetNumberOfAxesTicks(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrigin(self, origin:MutableSequence[float]) -> None: ...
    def GetStartAngle(self) -> float: ...
    def HasOpaqueGeometry(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolarAxesActor2D': ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolarAxesActor2D': ...
    def SetAxesLength(self, length:float) -> None: ...
    def SetAxesTextProperty(self, property:'vtkTextProperty') -> None: ...
    def SetEndAngle(self, angle:float) -> None: ...
    def SetNumberOfAxes(self, number:int) -> None: ...
    def SetNumberOfAxesTicks(self, number:int) -> None: ...
    @overload
    def SetOrigin(self, x:float, y:float) -> None: ...
    @overload
    def SetOrigin(self, origin:MutableSequence[float]) -> None: ...
    def SetStartAngle(self, angle:float) -> None: ...

class vtkProp3DAxisFollower(vtkmodules.vtkRenderingCore.vtkProp3DFollower):
    auto_center:'getset_descriptor'
    axis:'getset_descriptor'
    distance_lod_threshold:'getset_descriptor'
    enable_distance_lod:'getset_descriptor'
    enable_view_angle_lod:'getset_descriptor'
    screen_offset:'getset_descriptor'
    screen_offset_vector:'getset_descriptor'
    view_angle_lod_threshold:'getset_descriptor'
    viewport:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AutoCenterOff(self) -> None: ...
    def AutoCenterOn(self) -> None: ...
    @staticmethod
    def AutoScale(viewport:'vtkViewport', camera:'vtkCamera', screenSize:float, position:MutableSequence[float]) -> float: ...
    def ComputeMatrix(self) -> None: ...
    def GetAutoCenter(self) -> int: ...
    def GetAxis(self) -> 'vtkAxisActor': ...
    def GetDistanceLODThreshold(self) -> float: ...
    def GetDistanceLODThresholdMaxValue(self) -> float: ...
    def GetDistanceLODThresholdMinValue(self) -> float: ...
    def GetEnableDistanceLOD(self) -> int: ...
    def GetEnableViewAngleLOD(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScreenOffset(self) -> float: ...
    def GetScreenOffsetVector(self) -> Tuple[float, float]: ...
    def GetViewAngleLODThreshold(self) -> float: ...
    def GetViewAngleLODThresholdMaxValue(self) -> float: ...
    def GetViewAngleLODThresholdMinValue(self) -> float: ...
    def GetViewport(self) -> 'vtkViewport': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProp3DAxisFollower': ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderVolumetricGeometry(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProp3DAxisFollower': ...
    def SetAutoCenter(self, _arg:int) -> None: ...
    def SetAxis(self, __a:'vtkAxisActor') -> None: ...
    def SetDistanceLODThreshold(self, _arg:float) -> None: ...
    def SetEnableDistanceLOD(self, _arg:int) -> None: ...
    def SetEnableViewAngleLOD(self, _arg:int) -> None: ...
    def SetScreenOffset(self, offset:float) -> None: ...
    @overload
    def SetScreenOffsetVector(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScreenOffsetVector(self, _arg:Sequence[float]) -> None: ...
    def SetViewAngleLODThreshold(self, _arg:float) -> None: ...
    def SetViewport(self, viewport:'vtkViewport') -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...

class vtkRadialGridActor2D(vtkmodules.vtkRenderingCore.vtkActor2D):
    axes_viewport_length:'getset_descriptor'
    end_angle:'getset_descriptor'
    first_axes_points:'getset_descriptor'
    last_axes_points:'getset_descriptor'
    number_of_axes:'getset_descriptor'
    number_of_axes_max_value:'getset_descriptor'
    number_of_axes_min_value:'getset_descriptor'
    number_of_ticks:'getset_descriptor'
    number_of_ticks_max_value:'getset_descriptor'
    number_of_ticks_min_value:'getset_descriptor'
    origin:'getset_descriptor'
    start_angle:'getset_descriptor'
    text_property:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetActors2D(self, pc:'vtkPropCollection') -> None: ...
    def GetAxesViewportLength(self) -> float: ...
    def GetAxesViewportLengthMaxValue(self) -> float: ...
    def GetAxesViewportLengthMinValue(self) -> float: ...
    def GetEndAngle(self) -> float: ...
    def GetFirstAxesPoints(self) -> 'vtkPoints': ...
    def GetLastAxesPoints(self) -> 'vtkPoints': ...
    def GetNumberOfAxes(self) -> int: ...
    def GetNumberOfAxesMaxValue(self) -> int: ...
    def GetNumberOfAxesMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfTicks(self) -> int: ...
    def GetNumberOfTicksMaxValue(self) -> int: ...
    def GetNumberOfTicksMinValue(self) -> int: ...
    def GetOrigin(self) -> Tuple[float, float]: ...
    def GetStartAngle(self) -> float: ...
    def GetTextProperty(self) -> 'vtkTextProperty': ...
    def HasOpaqueGeometry(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRadialGridActor2D': ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRadialGridActor2D': ...
    def SetAxesViewportLength(self, _arg:float) -> None: ...
    def SetEndAngle(self, _arg:float) -> None: ...
    def SetNumberOfAxes(self, _arg:int) -> None: ...
    def SetNumberOfTicks(self, _arg:int) -> None: ...
    @overload
    def SetOrigin(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetOrigin(self, _arg:Sequence[float]) -> None: ...
    def SetStartAngle(self, _arg:float) -> None: ...
    def SetTextProperty(self, property:'vtkTextProperty') -> None: ...

class vtkScalarBarActor(vtkmodules.vtkRenderingCore.vtkActor2D):
    PrecedeScalarBar:int
    SucceedScalarBar:int
    above_range_annotation:'getset_descriptor'
    annotation_leader_padding:'getset_descriptor'
    annotation_text_property:'getset_descriptor'
    annotation_text_scaling:'getset_descriptor'
    background_property:'getset_descriptor'
    bar_ratio:'getset_descriptor'
    below_range_annotation:'getset_descriptor'
    component_title:'getset_descriptor'
    custom_labels:'getset_descriptor'
    draw_above_range_swatch:'getset_descriptor'
    draw_annotations:'getset_descriptor'
    draw_background:'getset_descriptor'
    draw_below_range_swatch:'getset_descriptor'
    draw_color_bar:'getset_descriptor'
    draw_frame:'getset_descriptor'
    draw_nan_annotation:'getset_descriptor'
    draw_tick_labels:'getset_descriptor'
    fixed_annotation_leader_line_color:'getset_descriptor'
    force_vertical_title:'getset_descriptor'
    frame_property:'getset_descriptor'
    label_format:'getset_descriptor'
    label_text_property:'getset_descriptor'
    lookup_table:'getset_descriptor'
    maximum_height_in_pixels:'getset_descriptor'
    maximum_number_of_colors:'getset_descriptor'
    maximum_width_in_pixels:'getset_descriptor'
    nan_annotation:'getset_descriptor'
    number_of_labels:'getset_descriptor'
    number_of_labels_max_value:'getset_descriptor'
    number_of_labels_min_value:'getset_descriptor'
    opacity_function:'getset_descriptor'
    orientation:'getset_descriptor'
    text_pad:'getset_descriptor'
    text_position:'getset_descriptor'
    texture_actor:'getset_descriptor'
    texture_grid_width:'getset_descriptor'
    title:'getset_descriptor'
    title_ratio:'getset_descriptor'
    title_text_property:'getset_descriptor'
    unconstrained_font_size:'getset_descriptor'
    use_custom_labels:'getset_descriptor'
    use_opacity:'getset_descriptor'
    vertical_title_separation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AnnotationTextScalingOff(self) -> None: ...
    def AnnotationTextScalingOn(self) -> None: ...
    def DrawAboveRangeSwatchOff(self) -> None: ...
    def DrawAboveRangeSwatchOn(self) -> None: ...
    def DrawAnnotationsOff(self) -> None: ...
    def DrawAnnotationsOn(self) -> None: ...
    def DrawBackgroundOff(self) -> None: ...
    def DrawBackgroundOn(self) -> None: ...
    def DrawBelowRangeSwatchOff(self) -> None: ...
    def DrawBelowRangeSwatchOn(self) -> None: ...
    def DrawColorBarOff(self) -> None: ...
    def DrawColorBarOn(self) -> None: ...
    def DrawFrameOff(self) -> None: ...
    def DrawFrameOn(self) -> None: ...
    def DrawNanAnnotationOff(self) -> None: ...
    def DrawNanAnnotationOn(self) -> None: ...
    def DrawTickLabelsOff(self) -> None: ...
    def DrawTickLabelsOn(self) -> None: ...
    def FixedAnnotationLeaderLineColorOff(self) -> None: ...
    def FixedAnnotationLeaderLineColorOn(self) -> None: ...
    def GetAboveRangeAnnotation(self) -> str: ...
    def GetAnnotationLeaderPadding(self) -> float: ...
    def GetAnnotationTextProperty(self) -> 'vtkTextProperty': ...
    def GetAnnotationTextScaling(self) -> int: ...
    def GetBackgroundProperty(self) -> 'vtkProperty2D': ...
    def GetBarRatio(self) -> float: ...
    def GetBarRatioMaxValue(self) -> float: ...
    def GetBarRatioMinValue(self) -> float: ...
    def GetBelowRangeAnnotation(self) -> str: ...
    def GetComponentTitle(self) -> str: ...
    def GetCustomLabels(self) -> 'vtkDoubleArray': ...
    def GetDrawAboveRangeSwatch(self) -> bool: ...
    def GetDrawAnnotations(self) -> int: ...
    def GetDrawBackground(self) -> int: ...
    def GetDrawBelowRangeSwatch(self) -> bool: ...
    def GetDrawColorBar(self) -> int: ...
    def GetDrawFrame(self) -> int: ...
    def GetDrawNanAnnotation(self) -> int: ...
    def GetDrawTickLabels(self) -> int: ...
    def GetFixedAnnotationLeaderLineColor(self) -> int: ...
    def GetForceVerticalTitle(self) -> bool: ...
    def GetFrameProperty(self) -> 'vtkProperty2D': ...
    def GetLabelFormat(self) -> str: ...
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetMaximumHeightInPixels(self) -> int: ...
    def GetMaximumNumberOfColors(self) -> int: ...
    def GetMaximumNumberOfColorsMaxValue(self) -> int: ...
    def GetMaximumNumberOfColorsMinValue(self) -> int: ...
    def GetMaximumWidthInPixels(self) -> int: ...
    def GetNanAnnotation(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfLabels(self) -> int: ...
    def GetNumberOfLabelsMaxValue(self) -> int: ...
    def GetNumberOfLabelsMinValue(self) -> int: ...
    def GetOpacityFunction(self) -> 'vtkPiecewiseFunction': ...
    def GetOrientation(self) -> int: ...
    def GetOrientationMaxValue(self) -> int: ...
    def GetOrientationMinValue(self) -> int: ...
    def GetScalarBarRect(self, rect:MutableSequence[int], viewport:'vtkViewport') -> None: ...
    def GetTextPad(self) -> int: ...
    def GetTextPosition(self) -> int: ...
    def GetTextPositionMaxValue(self) -> int: ...
    def GetTextPositionMinValue(self) -> int: ...
    def GetTextureActor(self) -> 'vtkTexturedActor2D': ...
    def GetTextureGridWidth(self) -> float: ...
    def GetTitle(self) -> str: ...
    def GetTitleRatio(self) -> float: ...
    def GetTitleRatioMaxValue(self) -> float: ...
    def GetTitleRatioMinValue(self) -> float: ...
    def GetTitleTextProperty(self) -> 'vtkTextProperty': ...
    def GetUnconstrainedFontSize(self) -> bool: ...
    def GetUseCustomLabels(self) -> bool: ...
    def GetUseOpacity(self) -> int: ...
    def GetVerticalTitleSeparation(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkScalarBarActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, viewport:'vtkViewport') -> int: ...
    def RenderOverlay(self, viewport:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkScalarBarActor': ...
    def SetAboveRangeAnnotation(self, _arg:str) -> None: ...
    def SetAnnotationLeaderPadding(self, _arg:float) -> None: ...
    def SetAnnotationTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetAnnotationTextScaling(self, _arg:int) -> None: ...
    def SetBackgroundProperty(self, p:'vtkProperty2D') -> None: ...
    def SetBarRatio(self, _arg:float) -> None: ...
    def SetBelowRangeAnnotation(self, _arg:str) -> None: ...
    def SetComponentTitle(self, _arg:str) -> None: ...
    def SetCustomLabels(self, labels:'vtkDoubleArray') -> None: ...
    def SetDrawAboveRangeSwatch(self, _arg:bool) -> None: ...
    def SetDrawAnnotations(self, _arg:int) -> None: ...
    def SetDrawBackground(self, _arg:int) -> None: ...
    def SetDrawBelowRangeSwatch(self, _arg:bool) -> None: ...
    def SetDrawColorBar(self, _arg:int) -> None: ...
    def SetDrawFrame(self, _arg:int) -> None: ...
    def SetDrawNanAnnotation(self, _arg:int) -> None: ...
    def SetDrawTickLabels(self, _arg:int) -> None: ...
    def SetFixedAnnotationLeaderLineColor(self, _arg:int) -> None: ...
    def SetForceVerticalTitle(self, _arg:bool) -> None: ...
    def SetFrameProperty(self, p:'vtkProperty2D') -> None: ...
    def SetLabelFormat(self, _arg:str) -> None: ...
    def SetLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetLookupTable(self, __a:'vtkScalarsToColors') -> None: ...
    def SetMaximumHeightInPixels(self, _arg:int) -> None: ...
    def SetMaximumNumberOfColors(self, _arg:int) -> None: ...
    def SetMaximumWidthInPixels(self, _arg:int) -> None: ...
    def SetNanAnnotation(self, _arg:str) -> None: ...
    def SetNumberOfLabels(self, _arg:int) -> None: ...
    def SetOpacityFunction(self, __a:'vtkPiecewiseFunction') -> None: ...
    def SetOrientation(self, _arg:int) -> None: ...
    def SetOrientationToHorizontal(self) -> None: ...
    def SetOrientationToVertical(self) -> None: ...
    def SetTextPad(self, _arg:int) -> None: ...
    def SetTextPosition(self, _arg:int) -> None: ...
    def SetTextPositionToPrecedeScalarBar(self) -> None: ...
    def SetTextPositionToSucceedScalarBar(self) -> None: ...
    def SetTextureGridWidth(self, _arg:float) -> None: ...
    def SetTitle(self, _arg:str) -> None: ...
    def SetTitleRatio(self, _arg:float) -> None: ...
    def SetTitleTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetUnconstrainedFontSize(self, _arg:bool) -> None: ...
    def SetUseCustomLabels(self, _arg:bool) -> None: ...
    def SetUseOpacity(self, _arg:int) -> None: ...
    def SetVerticalTitleSeparation(self, _arg:int) -> None: ...
    def ShallowCopy(self, prop:'vtkProp') -> None: ...
    def UnconstrainedFontSizeOff(self) -> None: ...
    def UnconstrainedFontSizeOn(self) -> None: ...
    def UseCustomLabelsOff(self) -> None: ...
    def UseCustomLabelsOn(self) -> None: ...
    def UseOpacityOff(self) -> None: ...
    def UseOpacityOn(self) -> None: ...

class vtkSpiderPlotActor(vtkmodules.vtkRenderingCore.vtkActor2D):
    independent_variables:'getset_descriptor'
    input:'getset_descriptor'
    input_connection:'getset_descriptor'
    input_data:'getset_descriptor'
    label_text_property:'getset_descriptor'
    label_visibility:'getset_descriptor'
    legend_actor:'getset_descriptor'
    legend_visibility:'getset_descriptor'
    number_of_rings:'getset_descriptor'
    number_of_rings_max_value:'getset_descriptor'
    number_of_rings_min_value:'getset_descriptor'
    title:'getset_descriptor'
    title_text_property:'getset_descriptor'
    title_visibility:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAxisLabel(self, i:int) -> str: ...
    def GetAxisRange(self, i:int, range:MutableSequence[float]) -> None: ...
    def GetIndependentVariables(self) -> int: ...
    def GetIndependentVariablesMaxValue(self) -> int: ...
    def GetIndependentVariablesMinValue(self) -> int: ...
    def GetInput(self) -> 'vtkDataObject': ...
    def GetLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetLabelVisibility(self) -> int: ...
    def GetLegendActor(self) -> 'vtkLegendBoxActor': ...
    def GetLegendVisibility(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfRings(self) -> int: ...
    def GetNumberOfRingsMaxValue(self) -> int: ...
    def GetNumberOfRingsMinValue(self) -> int: ...
    def GetPlotColor(self, i:int) -> Pointer: ...
    def GetTitle(self) -> str: ...
    def GetTitleTextProperty(self) -> 'vtkTextProperty': ...
    def GetTitleVisibility(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LabelVisibilityOff(self) -> None: ...
    def LabelVisibilityOn(self) -> None: ...
    def LegendVisibilityOff(self) -> None: ...
    def LegendVisibilityOn(self) -> None: ...
    def NewInstance(self) -> 'vtkSpiderPlotActor': ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSpiderPlotActor': ...
    def SetAxisLabel(self, i:int, __b:str) -> None: ...
    @overload
    def SetAxisRange(self, i:int, min:float, max:float) -> None: ...
    @overload
    def SetAxisRange(self, i:int, range:MutableSequence[float]) -> None: ...
    def SetIndependentVariables(self, _arg:int) -> None: ...
    def SetIndependentVariablesToColumns(self) -> None: ...
    def SetIndependentVariablesToRows(self) -> None: ...
    def SetInputConnection(self, __a:'vtkAlgorithmOutput') -> None: ...
    def SetInputData(self, __a:'vtkDataObject') -> None: ...
    def SetLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetLabelVisibility(self, _arg:int) -> None: ...
    def SetLegendVisibility(self, _arg:int) -> None: ...
    def SetNumberOfRings(self, _arg:int) -> None: ...
    @overload
    def SetPlotColor(self, i:int, r:float, g:float, b:float) -> None: ...
    @overload
    def SetPlotColor(self, i:int, color:Sequence[float]) -> None: ...
    def SetTitle(self, _arg:str) -> None: ...
    def SetTitleTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetTitleVisibility(self, _arg:int) -> None: ...
    def TitleVisibilityOff(self) -> None: ...
    def TitleVisibilityOn(self) -> None: ...

class vtkXYPlotActor(vtkmodules.vtkRenderingCore.vtkActor2D):
    class Alignment(int): ...
    AlignAxisBottom:'Alignment'
    AlignAxisHCenter:'Alignment'
    AlignAxisLeft:'Alignment'
    AlignAxisRight:'Alignment'
    AlignAxisTop:'Alignment'
    AlignAxisVCenter:'Alignment'
    AlignBottom:'Alignment'
    AlignHCenter:'Alignment'
    AlignLeft:'Alignment'
    AlignRight:'Alignment'
    AlignTop:'Alignment'
    AlignVCenter:'Alignment'
    adjust_title_position:'getset_descriptor'
    adjust_title_position_mode:'getset_descriptor'
    adjust_x_labels:'getset_descriptor'
    adjust_y_labels:'getset_descriptor'
    axis_label_bold:'getset_descriptor'
    axis_label_color:'getset_descriptor'
    axis_label_font_family:'getset_descriptor'
    axis_label_font_size:'getset_descriptor'
    axis_label_italic:'getset_descriptor'
    axis_label_justification:'getset_descriptor'
    axis_label_shadow:'getset_descriptor'
    axis_label_text_property:'getset_descriptor'
    axis_label_vertical_justification:'getset_descriptor'
    axis_title_bold:'getset_descriptor'
    axis_title_color:'getset_descriptor'
    axis_title_font_family:'getset_descriptor'
    axis_title_font_size:'getset_descriptor'
    axis_title_italic:'getset_descriptor'
    axis_title_justification:'getset_descriptor'
    axis_title_shadow:'getset_descriptor'
    axis_title_text_property:'getset_descriptor'
    axis_title_vertical_justification:'getset_descriptor'
    border:'getset_descriptor'
    chart_border:'getset_descriptor'
    chart_box:'getset_descriptor'
    chart_box_property:'getset_descriptor'
    data_object_plot_mode:'getset_descriptor'
    data_object_x_component:'getset_descriptor'
    data_object_y_component:'getset_descriptor'
    exchange_axes:'getset_descriptor'
    glyph_size:'getset_descriptor'
    glyph_source:'getset_descriptor'
    label_format:'getset_descriptor'
    legend:'getset_descriptor'
    legend_actor:'getset_descriptor'
    legend_background_color:'getset_descriptor'
    legend_border:'getset_descriptor'
    legend_box:'getset_descriptor'
    legend_position:'getset_descriptor'
    legend_position2:'getset_descriptor'
    legend_use_background:'getset_descriptor'
    line_width:'getset_descriptor'
    logx:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_data_object_input_connections:'getset_descriptor'
    number_of_data_set_input_connections:'getset_descriptor'
    number_of_labels:'getset_descriptor'
    number_of_x_labels:'getset_descriptor'
    number_of_x_labels_max_value:'getset_descriptor'
    number_of_x_labels_min_value:'getset_descriptor'
    number_of_x_minor_ticks:'getset_descriptor'
    number_of_y_labels:'getset_descriptor'
    number_of_y_labels_max_value:'getset_descriptor'
    number_of_y_labels_min_value:'getset_descriptor'
    number_of_y_minor_ticks:'getset_descriptor'
    plot_coordinate:'getset_descriptor'
    plot_curve_lines:'getset_descriptor'
    plot_curve_points:'getset_descriptor'
    plot_glyph_type:'getset_descriptor'
    plot_lines:'getset_descriptor'
    plot_points:'getset_descriptor'
    plot_range:'getset_descriptor'
    point_component:'getset_descriptor'
    reference_x_value:'getset_descriptor'
    reference_y_value:'getset_descriptor'
    reverse_x_axis:'getset_descriptor'
    reverse_y_axis:'getset_descriptor'
    show_reference_x_line:'getset_descriptor'
    show_reference_y_line:'getset_descriptor'
    title:'getset_descriptor'
    title_bold:'getset_descriptor'
    title_color:'getset_descriptor'
    title_font_family:'getset_descriptor'
    title_font_size:'getset_descriptor'
    title_italic:'getset_descriptor'
    title_justification:'getset_descriptor'
    title_position:'getset_descriptor'
    title_shadow:'getset_descriptor'
    title_text_property:'getset_descriptor'
    title_vertical_justification:'getset_descriptor'
    viewport_coordinate:'getset_descriptor'
    x_axis_actor2d:'getset_descriptor'
    x_axis_color:'getset_descriptor'
    x_label_format:'getset_descriptor'
    x_range:'getset_descriptor'
    x_title:'getset_descriptor'
    x_title_position:'getset_descriptor'
    x_values:'getset_descriptor'
    y_axis_actor2d:'getset_descriptor'
    y_axis_color:'getset_descriptor'
    y_label_format:'getset_descriptor'
    y_range:'getset_descriptor'
    y_title:'getset_descriptor'
    y_title_position:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddDataObjectInput(self, in_:'vtkDataObject') -> None: ...
    def AddDataObjectInputConnection(self, alg:'vtkAlgorithmOutput') -> None: ...
    @overload
    def AddDataSetInput(self, ds:'vtkDataSet', arrayName:str, component:int) -> None: ...
    @overload
    def AddDataSetInput(self, ds:'vtkDataSet') -> None: ...
    @overload
    def AddDataSetInputConnection(self, in_:'vtkAlgorithmOutput', arrayName:str, component:int) -> None: ...
    @overload
    def AddDataSetInputConnection(self, in_:'vtkAlgorithmOutput') -> None: ...
    def AddUserCurvesPoint(self, __a:float, __b:float, __c:float) -> None: ...
    def AdjustTitlePositionOff(self) -> None: ...
    def AdjustTitlePositionOn(self) -> None: ...
    def ChartBorderOff(self) -> None: ...
    def ChartBorderOn(self) -> None: ...
    def ChartBoxOff(self) -> None: ...
    def ChartBoxOn(self) -> None: ...
    def ExchangeAxesOff(self) -> None: ...
    def ExchangeAxesOn(self) -> None: ...
    def GetAdjustTitlePosition(self) -> int: ...
    def GetAdjustTitlePositionMode(self) -> int: ...
    def GetAdjustXLabels(self) -> int: ...
    def GetAdjustYLabels(self) -> int: ...
    def GetAxisLabelTextProperty(self) -> 'vtkTextProperty': ...
    def GetAxisTitleTextProperty(self) -> 'vtkTextProperty': ...
    def GetBorder(self) -> int: ...
    def GetBorderMaxValue(self) -> int: ...
    def GetBorderMinValue(self) -> int: ...
    def GetChartBorder(self) -> int: ...
    def GetChartBox(self) -> int: ...
    def GetChartBoxProperty(self) -> 'vtkProperty2D': ...
    def GetDataObjectInputConnection(self, idx:int) -> 'vtkAlgorithmOutput': ...
    def GetDataObjectPlotMode(self) -> int: ...
    def GetDataObjectPlotModeAsString(self) -> str: ...
    def GetDataObjectPlotModeMaxValue(self) -> int: ...
    def GetDataObjectPlotModeMinValue(self) -> int: ...
    def GetDataObjectXComponent(self, i:int) -> int: ...
    def GetDataObjectYComponent(self, i:int) -> int: ...
    def GetDataSetInputConnection(self, idx:int) -> 'vtkAlgorithmOutput': ...
    def GetExchangeAxes(self) -> int: ...
    def GetGlyphSize(self) -> float: ...
    def GetGlyphSizeMaxValue(self) -> float: ...
    def GetGlyphSizeMinValue(self) -> float: ...
    def GetGlyphSource(self) -> 'vtkGlyphSource2D': ...
    def GetLabelFormat(self) -> str: ...
    def GetLegend(self) -> int: ...
    def GetLegendActor(self) -> 'vtkLegendBoxActor': ...
    def GetLegendPosition(self) -> Tuple[float, float]: ...
    def GetLegendPosition2(self) -> Tuple[float, float]: ...
    def GetLogx(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfDataObjectInputConnections(self) -> int: ...
    def GetNumberOfDataSetInputConnections(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfXLabels(self) -> int: ...
    def GetNumberOfXLabelsMaxValue(self) -> int: ...
    def GetNumberOfXLabelsMinValue(self) -> int: ...
    def GetNumberOfXMinorTicks(self) -> int: ...
    def GetNumberOfYLabels(self) -> int: ...
    def GetNumberOfYLabelsMaxValue(self) -> int: ...
    def GetNumberOfYLabelsMinValue(self) -> int: ...
    def GetNumberOfYMinorTicks(self) -> int: ...
    def GetPlotColor(self, i:int) -> Tuple[float, float, float]: ...
    def GetPlotCoordinate(self) -> Tuple[float, float]: ...
    def GetPlotCurveLines(self) -> int: ...
    def GetPlotCurvePoints(self) -> int: ...
    def GetPlotLabel(self, i:int) -> str: ...
    @overload
    def GetPlotLines(self, i:int) -> int: ...
    @overload
    def GetPlotLines(self) -> int: ...
    @overload
    def GetPlotPoints(self, i:int) -> int: ...
    @overload
    def GetPlotPoints(self) -> int: ...
    def GetPlotSymbol(self, i:int) -> 'vtkPolyData': ...
    def GetPointComponent(self, i:int) -> int: ...
    def GetReferenceXValue(self) -> float: ...
    def GetReferenceYValue(self) -> float: ...
    def GetReverseXAxis(self) -> int: ...
    def GetReverseYAxis(self) -> int: ...
    def GetShowReferenceXLine(self) -> int: ...
    def GetShowReferenceYLine(self) -> int: ...
    def GetTitle(self) -> str: ...
    def GetTitlePosition(self) -> Tuple[float, float]: ...
    def GetTitleTextProperty(self) -> 'vtkTextProperty': ...
    def GetViewportCoordinate(self) -> Tuple[float, float]: ...
    def GetXAxisActor2D(self) -> 'vtkAxisActor2D': ...
    def GetXLabelFormat(self) -> str: ...
    def GetXRange(self) -> Tuple[float, float]: ...
    def GetXTitle(self) -> str: ...
    def GetXTitlePosition(self) -> float: ...
    def GetXValues(self) -> int: ...
    def GetXValuesAsString(self) -> str: ...
    def GetXValuesMaxValue(self) -> int: ...
    def GetXValuesMinValue(self) -> int: ...
    def GetYAxisActor2D(self) -> 'vtkAxisActor2D': ...
    def GetYLabelFormat(self) -> str: ...
    def GetYRange(self) -> Tuple[float, float]: ...
    def GetYTitle(self) -> str: ...
    def GetYTitlePosition(self) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    def IsInPlot(self, viewport:'vtkViewport', u:float, v:float) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LegendOff(self) -> None: ...
    def LegendOn(self) -> None: ...
    def LogxOff(self) -> None: ...
    def LogxOn(self) -> None: ...
    def NewInstance(self) -> 'vtkXYPlotActor': ...
    def PlotCurveLinesOff(self) -> None: ...
    def PlotCurveLinesOn(self) -> None: ...
    def PlotCurvePointsOff(self) -> None: ...
    def PlotCurvePointsOn(self) -> None: ...
    def PlotLinesOff(self) -> None: ...
    def PlotLinesOn(self) -> None: ...
    def PlotPointsOff(self) -> None: ...
    def PlotPointsOn(self) -> None: ...
    @overload
    def PlotToViewportCoordinate(self, viewport:'vtkViewport', u:float, v:float) -> None: ...
    @overload
    def PlotToViewportCoordinate(self, viewport:'vtkViewport') -> None: ...
    def ReleaseGraphicsResources(self, __a:'vtkWindow') -> None: ...
    def RemoveAllActiveCurves(self) -> None: ...
    def RemoveAllDataObjectInputConnections(self) -> None: ...
    def RemoveAllDataSetInputConnections(self) -> None: ...
    def RemoveDataObjectInput(self, in_:'vtkDataObject') -> None: ...
    def RemoveDataObjectInputConnection(self, aout:'vtkAlgorithmOutput') -> None: ...
    @overload
    def RemoveDataSetInput(self, ds:'vtkDataSet', arrayName:str, component:int) -> None: ...
    @overload
    def RemoveDataSetInput(self, ds:'vtkDataSet') -> None: ...
    @overload
    def RemoveDataSetInputConnection(self, in_:'vtkAlgorithmOutput', arrayName:str, component:int) -> None: ...
    @overload
    def RemoveDataSetInputConnection(self, in_:'vtkAlgorithmOutput') -> None: ...
    def RenderOpaqueGeometry(self, __a:'vtkViewport') -> int: ...
    def RenderOverlay(self, __a:'vtkViewport') -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:'vtkViewport') -> int: ...
    def ReverseXAxisOff(self) -> None: ...
    def ReverseXAxisOn(self) -> None: ...
    def ReverseYAxisOff(self) -> None: ...
    def ReverseYAxisOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkXYPlotActor': ...
    def SetAdjustTitlePosition(self, _arg:int) -> None: ...
    def SetAdjustTitlePositionMode(self, _arg:int) -> None: ...
    def SetAdjustXLabels(self, adjust:int) -> None: ...
    def SetAdjustYLabels(self, adjust:int) -> None: ...
    def SetAxisLabelBold(self, __a:int) -> None: ...
    def SetAxisLabelColor(self, __a:float, __b:float, __c:float) -> None: ...
    def SetAxisLabelFontFamily(self, __a:int) -> None: ...
    def SetAxisLabelFontSize(self, __a:int) -> None: ...
    def SetAxisLabelItalic(self, __a:int) -> None: ...
    def SetAxisLabelJustification(self, __a:int) -> None: ...
    def SetAxisLabelShadow(self, __a:int) -> None: ...
    def SetAxisLabelTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetAxisLabelVerticalJustification(self, __a:int) -> None: ...
    def SetAxisTitleBold(self, __a:int) -> None: ...
    def SetAxisTitleColor(self, __a:float, __b:float, __c:float) -> None: ...
    def SetAxisTitleFontFamily(self, __a:int) -> None: ...
    def SetAxisTitleFontSize(self, __a:int) -> None: ...
    def SetAxisTitleItalic(self, __a:int) -> None: ...
    def SetAxisTitleJustification(self, __a:int) -> None: ...
    def SetAxisTitleShadow(self, __a:int) -> None: ...
    def SetAxisTitleTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetAxisTitleVerticalJustification(self, __a:int) -> None: ...
    def SetBorder(self, _arg:int) -> None: ...
    def SetChartBorder(self, _arg:int) -> None: ...
    def SetChartBox(self, _arg:int) -> None: ...
    def SetDataObjectPlotMode(self, _arg:int) -> None: ...
    def SetDataObjectPlotModeToColumns(self) -> None: ...
    def SetDataObjectPlotModeToRows(self) -> None: ...
    def SetDataObjectXComponent(self, i:int, comp:int) -> None: ...
    def SetDataObjectYComponent(self, i:int, comp:int) -> None: ...
    def SetExchangeAxes(self, _arg:int) -> None: ...
    def SetGlyphSize(self, _arg:float) -> None: ...
    def SetLabelFormat(self, __a:str) -> None: ...
    def SetLegend(self, _arg:int) -> None: ...
    def SetLegendBackgroundColor(self, __a:float, __b:float, __c:float) -> None: ...
    def SetLegendBorder(self, __a:int) -> None: ...
    def SetLegendBox(self, __a:int) -> None: ...
    @overload
    def SetLegendPosition(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetLegendPosition(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetLegendPosition2(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetLegendPosition2(self, _arg:Sequence[float]) -> None: ...
    def SetLegendUseBackground(self, __a:int) -> None: ...
    def SetLineWidth(self, __a:float) -> None: ...
    def SetLogx(self, _arg:int) -> None: ...
    def SetNumberOfLabels(self, num:int) -> None: ...
    def SetNumberOfXLabels(self, _arg:int) -> None: ...
    def SetNumberOfXMinorTicks(self, num:int) -> None: ...
    def SetNumberOfYLabels(self, _arg:int) -> None: ...
    def SetNumberOfYMinorTicks(self, num:int) -> None: ...
    @overload
    def SetPlotColor(self, i:int, r:float, g:float, b:float) -> None: ...
    @overload
    def SetPlotColor(self, i:int, color:Sequence[float]) -> None: ...
    @overload
    def SetPlotCoordinate(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetPlotCoordinate(self, _arg:Sequence[float]) -> None: ...
    def SetPlotCurveLines(self, _arg:int) -> None: ...
    def SetPlotCurvePoints(self, _arg:int) -> None: ...
    def SetPlotGlyphType(self, __a:int, __b:int) -> None: ...
    def SetPlotLabel(self, i:int, label:str) -> None: ...
    @overload
    def SetPlotLines(self, i:int, __b:int) -> None: ...
    @overload
    def SetPlotLines(self, _arg:int) -> None: ...
    @overload
    def SetPlotPoints(self, i:int, __b:int) -> None: ...
    @overload
    def SetPlotPoints(self, _arg:int) -> None: ...
    def SetPlotRange(self, xmin:float, ymin:float, xmax:float, ymax:float) -> None: ...
    def SetPlotSymbol(self, i:int, input:'vtkPolyData') -> None: ...
    def SetPointComponent(self, i:int, comp:int) -> None: ...
    def SetReferenceXValue(self, _arg:float) -> None: ...
    def SetReferenceYValue(self, _arg:float) -> None: ...
    def SetReverseXAxis(self, _arg:int) -> None: ...
    def SetReverseYAxis(self, _arg:int) -> None: ...
    def SetShowReferenceXLine(self, _arg:int) -> None: ...
    def SetShowReferenceYLine(self, _arg:int) -> None: ...
    def SetTitle(self, _arg:str) -> None: ...
    def SetTitleBold(self, __a:int) -> None: ...
    def SetTitleColor(self, __a:float, __b:float, __c:float) -> None: ...
    def SetTitleFontFamily(self, __a:int) -> None: ...
    def SetTitleFontSize(self, __a:int) -> None: ...
    def SetTitleItalic(self, __a:int) -> None: ...
    def SetTitleJustification(self, __a:int) -> None: ...
    @overload
    def SetTitlePosition(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetTitlePosition(self, _arg:Sequence[float]) -> None: ...
    def SetTitleShadow(self, __a:int) -> None: ...
    def SetTitleTextProperty(self, p:'vtkTextProperty') -> None: ...
    def SetTitleVerticalJustification(self, __a:int) -> None: ...
    @overload
    def SetViewportCoordinate(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetViewportCoordinate(self, _arg:Sequence[float]) -> None: ...
    def SetXAxisColor(self, __a:float, __b:float, __c:float) -> None: ...
    def SetXLabelFormat(self, __a:str) -> None: ...
    @overload
    def SetXRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetXRange(self, _arg:Sequence[float]) -> None: ...
    def SetXTitle(self, _arg:str) -> None: ...
    def SetXTitlePosition(self, position:float) -> None: ...
    def SetXValues(self, _arg:int) -> None: ...
    def SetXValuesToArcLength(self) -> None: ...
    def SetXValuesToIndex(self) -> None: ...
    def SetXValuesToNormalizedArcLength(self) -> None: ...
    def SetXValuesToValue(self) -> None: ...
    def SetYAxisColor(self, __a:float, __b:float, __c:float) -> None: ...
    def SetYLabelFormat(self, __a:str) -> None: ...
    @overload
    def SetYRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetYRange(self, _arg:Sequence[float]) -> None: ...
    def SetYTitle(self, __a:str) -> None: ...
    def SetYTitlePosition(self, _arg:int) -> None: ...
    def SetYTitlePositionToHCenter(self) -> None: ...
    def SetYTitlePositionToTop(self) -> None: ...
    def SetYTitlePositionToVCenter(self) -> None: ...
    def ShowReferenceXLineOff(self) -> None: ...
    def ShowReferenceXLineOn(self) -> None: ...
    def ShowReferenceYLineOff(self) -> None: ...
    def ShowReferenceYLineOn(self) -> None: ...
    @overload
    def ViewportToPlotCoordinate(self, viewport:'vtkViewport', u:float, v:float) -> None: ...
    @overload
    def ViewportToPlotCoordinate(self, viewport:'vtkViewport') -> None: ...

