from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkIOCore

class vtkHDFReader(vtkmodules.vtkCommonExecutionModel.vtkDataObjectAlgorithm):
    cell_data_array_selection:'getset_descriptor'
    field_data_array_selection:'getset_descriptor'
    file_name:'getset_descriptor'
    has_temporal_data:'getset_descriptor'
    has_transient_data:'getset_descriptor'
    maximum_levels_to_read_by_default_for_amr:'getset_descriptor'
    merge_parts:'getset_descriptor'
    number_of_cell_arrays:'getset_descriptor'
    number_of_point_arrays:'getset_descriptor'
    output_as_data_set:'getset_descriptor'
    point_data_array_selection:'getset_descriptor'
    step:'getset_descriptor'
    time_value:'getset_descriptor'
    use_cache:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CanReadFile(self, name:str) -> int: ...
    def GetAttributeOriginalIdName(self, attribute:int) -> str: ...
    def GetCellArrayName(self, index:int) -> str: ...
    def GetCellDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetFieldDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetFileName(self) -> str: ...
    def GetHasTemporalData(self) -> bool: ...
    def GetHasTransientData(self) -> bool: ...
    def GetMaximumLevelsToReadByDefaultForAMR(self) -> int: ...
    def GetMergeParts(self) -> bool: ...
    def GetNumberOfCellArrays(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfPointArrays(self) -> int: ...
    def GetNumberOfSteps(self) -> int: ...
    @overload
    def GetOutputAsDataSet(self) -> 'vtkDataSet': ...
    @overload
    def GetOutputAsDataSet(self, index:int) -> 'vtkDataSet': ...
    def GetPointArrayName(self, index:int) -> str: ...
    def GetPointDataArraySelection(self) -> 'vtkDataArraySelection': ...
    def GetStep(self) -> int: ...
    def GetTimeValue(self) -> float: ...
    def GetUseCache(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergePartsOff(self) -> None: ...
    def MergePartsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkHDFReader': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHDFReader': ...
    def SetAttributeOriginalIdName(self, attribute:int, name:str) -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetMaximumLevelsToReadByDefaultForAMR(self, _arg:int) -> None: ...
    def SetMergeParts(self, _arg:bool) -> None: ...
    def SetStep(self, _arg:int) -> None: ...
    def SetUseCache(self, _arg:bool) -> None: ...
    def UseCacheOff(self) -> None: ...
    def UseCacheOn(self) -> None: ...

class vtkHDFWriter(vtkmodules.vtkIOCore.vtkWriter):
    chunk_size:'getset_descriptor'
    compression_level:'getset_descriptor'
    controller:'getset_descriptor'
    file_name:'getset_descriptor'
    overwrite:'getset_descriptor'
    use_external_composite:'getset_descriptor'
    use_external_partitions:'getset_descriptor'
    use_external_time_steps:'getset_descriptor'
    write_all_time_steps:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetChunkSize(self) -> int: ...
    def GetCompressionLevel(self) -> int: ...
    def GetCompressionLevelMaxValue(self) -> int: ...
    def GetCompressionLevelMinValue(self) -> int: ...
    def GetController(self) -> 'vtkMultiProcessController': ...
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOverwrite(self) -> bool: ...
    def GetUseExternalComposite(self) -> bool: ...
    def GetUseExternalPartitions(self) -> bool: ...
    def GetUseExternalTimeSteps(self) -> bool: ...
    def GetWriteAllTimeSteps(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHDFWriter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHDFWriter': ...
    def SetChunkSize(self, _arg:int) -> None: ...
    def SetCompressionLevel(self, _arg:int) -> None: ...
    def SetController(self, __a:'vtkMultiProcessController') -> None: ...
    def SetFileName(self, _arg:str) -> None: ...
    def SetOverwrite(self, _arg:bool) -> None: ...
    def SetUseExternalComposite(self, _arg:bool) -> None: ...
    def SetUseExternalPartitions(self, _arg:bool) -> None: ...
    def SetUseExternalTimeSteps(self, _arg:bool) -> None: ...
    def SetWriteAllTimeSteps(self, _arg:bool) -> None: ...

