from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel
import vtkmodules.vtkFiltersGeneral

VTK_DIJKSTRA_EDGE_SEARCH:int
VTK_GREEDY_EDGE_SEARCH:int
VTK_INSIDE_CLOSEST_POINT_REGION:int
VTK_INSIDE_LARGEST_REGION:int
VTK_INSIDE_SMALLEST_REGION:int
VTK_LOOP_CLOSURE_ALL:int
VTK_LOOP_CLOSURE_BOUNDARY:int
VTK_LOOP_CLOSURE_OFF:int
VTK_MAX_SPHERE_RESOLUTION:int
VTK_NORMAL_EXTRUSION:int
VTK_OUTPUT_BOTH:int
VTK_OUTPUT_POLYGONS:int
VTK_OUTPUT_POLYLINES:int
VTK_POINT_EXTRUSION:int
VTK_PROJECTED_TEXTURE_USE_PINHOLE:int
VTK_PROJECTED_TEXTURE_USE_TWO_MIRRORS:int
VTK_RULED_MODE_POINT_WALK:int
VTK_RULED_MODE_RESAMPLE:int
VTK_SCALAR_MODE_INDEX:int
VTK_SCALAR_MODE_VALUE:int
VTK_TCOORDS_FROM_LENGTH:int
VTK_TCOORDS_FROM_NORMALIZED_LENGTH:int
VTK_TCOORDS_FROM_SCALARS:int
VTK_TCOORDS_OFF:int
VTK_VECTOR_EXTRUSION:int

class vtkAdaptiveSubdivisionFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    locator:'getset_descriptor'
    m_time:'getset_descriptor'
    maximum_edge_length:'getset_descriptor'
    maximum_number_of_passes:'getset_descriptor'
    maximum_number_of_triangles:'getset_descriptor'
    maximum_triangle_area:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMTime(self) -> int: ...
    def GetMaximumEdgeLength(self) -> float: ...
    def GetMaximumEdgeLengthMaxValue(self) -> float: ...
    def GetMaximumEdgeLengthMinValue(self) -> float: ...
    def GetMaximumNumberOfPasses(self) -> int: ...
    def GetMaximumNumberOfPassesMaxValue(self) -> int: ...
    def GetMaximumNumberOfPassesMinValue(self) -> int: ...
    def GetMaximumNumberOfTriangles(self) -> int: ...
    def GetMaximumNumberOfTrianglesMaxValue(self) -> int: ...
    def GetMaximumNumberOfTrianglesMinValue(self) -> int: ...
    def GetMaximumTriangleArea(self) -> float: ...
    def GetMaximumTriangleAreaMaxValue(self) -> float: ...
    def GetMaximumTriangleAreaMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkAdaptiveSubdivisionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkAdaptiveSubdivisionFilter': ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetMaximumEdgeLength(self, _arg:float) -> None: ...
    def SetMaximumNumberOfPasses(self, _arg:int) -> None: ...
    def SetMaximumNumberOfTriangles(self, _arg:int) -> None: ...
    def SetMaximumTriangleArea(self, _arg:float) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...

class vtkBandedPolyDataContourFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    clip_tolerance:'getset_descriptor'
    clipping:'getset_descriptor'
    component:'getset_descriptor'
    contour_edges_output:'getset_descriptor'
    generate_contour_edges:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_contours:'getset_descriptor'
    scalar_mode:'getset_descriptor'
    values:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def ClippingOff(self) -> None: ...
    def ClippingOn(self) -> None: ...
    def GenerateContourEdgesOff(self) -> None: ...
    def GenerateContourEdgesOn(self) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, range:MutableSequence[float]) -> None: ...
    @overload
    def GenerateValues(self, numContours:int, rangeStart:float, rangeEnd:float) -> None: ...
    def GetClipTolerance(self) -> float: ...
    def GetClipping(self) -> int: ...
    def GetComponent(self) -> int: ...
    def GetContourEdgesOutput(self) -> 'vtkPolyData': ...
    def GetGenerateContourEdges(self) -> int: ...
    def GetMTime(self) -> int: ...
    def GetNumberOfContours(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScalarMode(self) -> int: ...
    def GetScalarModeMaxValue(self) -> int: ...
    def GetScalarModeMinValue(self) -> int: ...
    def GetValue(self, i:int) -> float: ...
    @overload
    def GetValues(self) -> Pointer: ...
    @overload
    def GetValues(self, contourValues:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkBandedPolyDataContourFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkBandedPolyDataContourFilter': ...
    def SetClipTolerance(self, _arg:float) -> None: ...
    def SetClipping(self, _arg:int) -> None: ...
    def SetComponent(self, _arg:int) -> None: ...
    def SetGenerateContourEdges(self, _arg:int) -> None: ...
    def SetNumberOfContours(self, number:int) -> None: ...
    def SetScalarMode(self, _arg:int) -> None: ...
    def SetScalarModeToIndex(self) -> None: ...
    def SetScalarModeToValue(self) -> None: ...
    def SetValue(self, i:int, value:float) -> None: ...

class vtkButterflySubdivisionFilter(vtkmodules.vtkFiltersGeneral.vtkInterpolatingSubdivisionFilter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkButterflySubdivisionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkButterflySubdivisionFilter': ...

class vtkCollisionDetectionFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class CollisionModes(int): ...
    VTK_ALL_CONTACTS:'CollisionModes'
    VTK_FIRST_CONTACT:'CollisionModes'
    VTK_HALF_CONTACTS:'CollisionModes'
    box_tolerance:'getset_descriptor'
    cell_tolerance:'getset_descriptor'
    collision_mode:'getset_descriptor'
    contacts_output:'getset_descriptor'
    contacts_output_port:'getset_descriptor'
    generate_scalars:'getset_descriptor'
    m_time:'getset_descriptor'
    number_of_box_tests:'getset_descriptor'
    number_of_cells_per_node:'getset_descriptor'
    number_of_contacts:'getset_descriptor'
    opacity:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateScalarsOff(self) -> None: ...
    def GenerateScalarsOn(self) -> None: ...
    def GetBoxTolerance(self) -> float: ...
    def GetCellTolerance(self) -> float: ...
    def GetCollisionMode(self) -> int: ...
    def GetCollisionModeAsString(self) -> str: ...
    def GetCollisionModeMaxValue(self) -> int: ...
    def GetCollisionModeMinValue(self) -> int: ...
    def GetContactCells(self, i:int) -> 'vtkIdTypeArray': ...
    def GetContactsOutput(self) -> 'vtkPolyData': ...
    def GetContactsOutputPort(self) -> 'vtkAlgorithmOutput': ...
    def GetGenerateScalars(self) -> int: ...
    def GetInputData(self, i:int) -> 'vtkPolyData': ...
    def GetMTime(self) -> int: ...
    def GetMatrix(self, i:int) -> 'vtkMatrix4x4': ...
    def GetNumberOfBoxTests(self) -> int: ...
    def GetNumberOfCellsPerNode(self) -> int: ...
    def GetNumberOfContacts(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOpacity(self) -> float: ...
    def GetOpacityMaxValue(self) -> float: ...
    def GetOpacityMinValue(self) -> float: ...
    def GetTransform(self, i:int) -> 'vtkLinearTransform': ...
    def IntersectPolygonWithPolygon(self, npts:int, pts:MutableSequence[float], bounds:MutableSequence[float], npts2:int, pts2:MutableSequence[float], bounds2:MutableSequence[float], tol2:float, x1:MutableSequence[float], x2:MutableSequence[float], CollisionMode:int) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCollisionDetectionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCollisionDetectionFilter': ...
    def SetBoxTolerance(self, _arg:float) -> None: ...
    def SetCellTolerance(self, _arg:float) -> None: ...
    def SetCollisionMode(self, _arg:int) -> None: ...
    def SetCollisionModeToAllContacts(self) -> None: ...
    def SetCollisionModeToFirstContact(self) -> None: ...
    def SetCollisionModeToHalfContacts(self) -> None: ...
    def SetGenerateScalars(self, _arg:int) -> None: ...
    def SetInputData(self, i:int, model:'vtkPolyData') -> None: ...
    def SetMatrix(self, i:int, matrix:'vtkMatrix4x4') -> None: ...
    def SetNumberOfCellsPerNode(self, _arg:int) -> None: ...
    def SetOpacity(self, _arg:float) -> None: ...
    def SetTransform(self, i:int, transform:'vtkLinearTransform') -> None: ...

class vtkContourLoopExtraction(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    clean_points:'getset_descriptor'
    loop_closure:'getset_descriptor'
    normal:'getset_descriptor'
    output_mode:'getset_descriptor'
    scalar_range:'getset_descriptor'
    scalar_thresholding:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CleanPointsOff(self) -> None: ...
    def CleanPointsOn(self) -> None: ...
    def GetCleanPoints(self) -> bool: ...
    def GetLoopClosure(self) -> int: ...
    def GetLoopClosureAsString(self) -> str: ...
    def GetLoopClosureMaxValue(self) -> int: ...
    def GetLoopClosureMinValue(self) -> int: ...
    def GetNormal(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputMode(self) -> int: ...
    def GetOutputModeAsString(self) -> str: ...
    def GetOutputModeMaxValue(self) -> int: ...
    def GetOutputModeMinValue(self) -> int: ...
    def GetScalarRange(self) -> Tuple[float, float]: ...
    def GetScalarThresholding(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkContourLoopExtraction': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkContourLoopExtraction': ...
    def ScalarThresholdingOff(self) -> None: ...
    def ScalarThresholdingOn(self) -> None: ...
    def SetCleanPoints(self, _arg:bool) -> None: ...
    def SetLoopClosure(self, _arg:int) -> None: ...
    def SetLoopClosureToAll(self) -> None: ...
    def SetLoopClosureToBoundary(self) -> None: ...
    def SetLoopClosureToOff(self) -> None: ...
    @overload
    def SetNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetNormal(self, _arg:Sequence[float]) -> None: ...
    def SetOutputMode(self, _arg:int) -> None: ...
    def SetOutputModeToBoth(self) -> None: ...
    def SetOutputModeToPolygons(self) -> None: ...
    def SetOutputModeToPolylines(self) -> None: ...
    @overload
    def SetScalarRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetScalarRange(self, _arg:Sequence[float]) -> None: ...
    def SetScalarThresholding(self, _arg:bool) -> None: ...

class vtkCookieCutter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class PointInterpolationType(int): ...
    USE_LOOP_EDGES:'PointInterpolationType'
    USE_MESH_EDGES:'PointInterpolationType'
    locator:'getset_descriptor'
    loops:'getset_descriptor'
    loops_connection:'getset_descriptor'
    loops_data:'getset_descriptor'
    pass_cell_data:'getset_descriptor'
    pass_point_data:'getset_descriptor'
    point_interpolation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetLoops(self) -> 'vtkDataObject': ...
    def GetLoopsConnection(self) -> 'vtkAlgorithmOutput': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPassCellData(self) -> bool: ...
    def GetPassPointData(self) -> bool: ...
    def GetPointInterpolation(self) -> int: ...
    def GetPointInterpolationMaxValue(self) -> int: ...
    def GetPointInterpolationMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkCookieCutter': ...
    def PassCellDataOff(self) -> None: ...
    def PassCellDataOn(self) -> None: ...
    def PassPointDataOff(self) -> None: ...
    def PassPointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkCookieCutter': ...
    def SetLocator(self, locator:'vtkIncrementalPointLocator') -> None: ...
    def SetLoopsConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetLoopsData(self, loops:'vtkDataObject') -> None: ...
    def SetPassCellData(self, _arg:bool) -> None: ...
    def SetPassPointData(self, _arg:bool) -> None: ...
    def SetPointInterpolation(self, _arg:int) -> None: ...
    def SetPointInterpolationToLoopEdges(self) -> None: ...
    def SetPointInterpolationToMeshEdges(self) -> None: ...

class vtkGeodesicPath(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGeodesicPath': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGeodesicPath': ...

class vtkGraphGeodesicPath(vtkGeodesicPath):
    end_vertex:'getset_descriptor'
    start_vertex:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetEndVertex(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStartVertex(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkGraphGeodesicPath': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkGraphGeodesicPath': ...
    def SetEndVertex(self, _arg:int) -> None: ...
    def SetStartVertex(self, _arg:int) -> None: ...

class vtkDijkstraGraphGeodesicPath(vtkGraphGeodesicPath):
    id_list:'getset_descriptor'
    repel_path_from_vertices:'getset_descriptor'
    repel_vertices:'getset_descriptor'
    stop_when_end_reached:'getset_descriptor'
    use_scalar_weights:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCumulativeWeights(self, weights:'vtkDoubleArray') -> None: ...
    def GetIdList(self) -> 'vtkIdList': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRepelPathFromVertices(self) -> int: ...
    def GetRepelVertices(self) -> 'vtkPoints': ...
    def GetStopWhenEndReached(self) -> int: ...
    def GetUseScalarWeights(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDijkstraGraphGeodesicPath': ...
    def RepelPathFromVerticesOff(self) -> None: ...
    def RepelPathFromVerticesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDijkstraGraphGeodesicPath': ...
    def SetRepelPathFromVertices(self, _arg:int) -> None: ...
    def SetRepelVertices(self, __a:'vtkPoints') -> None: ...
    def SetStopWhenEndReached(self, _arg:int) -> None: ...
    def SetUseScalarWeights(self, _arg:int) -> None: ...
    def StopWhenEndReachedOff(self) -> None: ...
    def StopWhenEndReachedOn(self) -> None: ...
    def UseScalarWeightsOff(self) -> None: ...
    def UseScalarWeightsOn(self) -> None: ...

class vtkDijkstraImageGeodesicPath(vtkDijkstraGraphGeodesicPath):
    curvature_weight:'getset_descriptor'
    edge_length_weight:'getset_descriptor'
    image_weight:'getset_descriptor'
    input_as_image_data:'getset_descriptor'
    input_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCurvatureWeight(self) -> float: ...
    def GetCurvatureWeightMaxValue(self) -> float: ...
    def GetCurvatureWeightMinValue(self) -> float: ...
    def GetEdgeLengthWeight(self) -> float: ...
    def GetImageWeight(self) -> float: ...
    def GetInputAsImageData(self) -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDijkstraImageGeodesicPath': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDijkstraImageGeodesicPath': ...
    def SetCurvatureWeight(self, _arg:float) -> None: ...
    def SetEdgeLengthWeight(self, __a:float) -> None: ...
    def SetImageWeight(self, __a:float) -> None: ...
    def SetInputData(self, __a:'vtkDataObject') -> None: ...

class vtkFillHolesFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    hole_size:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetHoleSize(self) -> float: ...
    def GetHoleSizeMaxValue(self) -> float: ...
    def GetHoleSizeMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFillHolesFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFillHolesFilter': ...
    def SetHoleSize(self, _arg:float) -> None: ...

class vtkFitToHeightMapFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class FittingStrategy(int): ...
    CELL_AVERAGE_HEIGHT:'FittingStrategy'
    CELL_MAXIMUM_HEIGHT:'FittingStrategy'
    CELL_MINIMUM_HEIGHT:'FittingStrategy'
    POINT_AVERAGE_HEIGHT:'FittingStrategy'
    POINT_MAXIMUM_HEIGHT:'FittingStrategy'
    POINT_MINIMUM_HEIGHT:'FittingStrategy'
    POINT_PROJECTION:'FittingStrategy'
    fitting_strategy:'getset_descriptor'
    height_map:'getset_descriptor'
    height_map_connection:'getset_descriptor'
    height_map_data:'getset_descriptor'
    use_height_map_offset:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetFittingStrategy(self) -> int: ...
    @overload
    def GetHeightMap(self) -> 'vtkImageData': ...
    @overload
    def GetHeightMap(self, sourceInfo:'vtkInformationVector') -> 'vtkImageData': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetUseHeightMapOffset(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkFitToHeightMapFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkFitToHeightMapFilter': ...
    def SetFittingStrategy(self, _arg:int) -> None: ...
    def SetFittingStrategyToAverageHeight(self) -> None: ...
    def SetFittingStrategyToCellAverageHeight(self) -> None: ...
    def SetFittingStrategyToCellMaximumHeight(self) -> None: ...
    def SetFittingStrategyToCellMinimumHeight(self) -> None: ...
    def SetFittingStrategyToPointMaximumHeight(self) -> None: ...
    def SetFittingStrategyToPointMinimumHeight(self) -> None: ...
    def SetFittingStrategyToPointProjection(self) -> None: ...
    def SetHeightMapConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetHeightMapData(self, idata:'vtkImageData') -> None: ...
    def SetUseHeightMapOffset(self, _arg:int) -> None: ...
    def UseHeightMapOffsetOff(self) -> None: ...
    def UseHeightMapOffsetOn(self) -> None: ...

class vtkHausdorffDistancePointSetFilter(vtkmodules.vtkCommonExecutionModel.vtkPointSetAlgorithm):
    class DistanceMethod(int): ...
    POINT_TO_CELL:'DistanceMethod'
    POINT_TO_POINT:'DistanceMethod'
    hausdorff_distance:'getset_descriptor'
    relative_distance:'getset_descriptor'
    target_distance_method:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetHausdorffDistance(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRelativeDistance(self) -> Tuple[float, float]: ...
    def GetTargetDistanceMethod(self) -> int: ...
    def GetTargetDistanceMethodAsString(self) -> str: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHausdorffDistancePointSetFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHausdorffDistancePointSetFilter': ...
    def SetTargetDistanceMethod(self, _arg:int) -> None: ...
    def SetTargetDistanceMethodToPointToCell(self) -> None: ...
    def SetTargetDistanceMethodToPointToPoint(self) -> None: ...

class vtkHyperTreeGridOutlineFilter(vtkmodules.vtkCommonExecutionModel.vtkHyperTreeGridAlgorithm):
    generate_faces:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateFacesOff(self) -> None: ...
    def GenerateFacesOn(self) -> None: ...
    def GetGenerateFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkHyperTreeGridOutlineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkHyperTreeGridOutlineFilter': ...
    def SetGenerateFaces(self, _arg:int) -> None: ...

class vtkImageDataOutlineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    generate_faces:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateFacesOff(self) -> None: ...
    def GenerateFacesOn(self) -> None: ...
    def GetGenerateFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImageDataOutlineFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImageDataOutlineFilter': ...
    def SetGenerateFaces(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...

class vtkImprintFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class MergeTolType(int): ...
    class ToleranceStrategy(int): ...
    class DebugOutput(int): ...
    class SpecifiedOutput(int): ...
    class PointInterpolationType(int): ...
    ABSOLUTE_TOLERANCE:'MergeTolType'
    DECOUPLED_TOLERANCES:'ToleranceStrategy'
    IMPRINTED_CELLS:'SpecifiedOutput'
    IMPRINTED_REGION:'SpecifiedOutput'
    LINKED_TOLERANCES:'ToleranceStrategy'
    MERGED_IMPRINT:'SpecifiedOutput'
    NO_DEBUG_OUTPUT:'DebugOutput'
    PROJECTED_IMPRINT:'SpecifiedOutput'
    RELATIVE_TO_AVERAGE_EDGE_LENGTH:'MergeTolType'
    RELATIVE_TO_MIN_EDGE_LENGTH:'MergeTolType'
    RELATIVE_TO_PROJECTION_TOLERANCE:'MergeTolType'
    TARGET_CELLS:'SpecifiedOutput'
    TRIANGULATION_INPUT:'DebugOutput'
    TRIANGULATION_OUTPUT:'DebugOutput'
    USE_IMPRINT_EDGES:'PointInterpolationType'
    USE_TARGET_EDGES:'PointInterpolationType'
    boundary_edge_insertion:'getset_descriptor'
    debug_cell_id:'getset_descriptor'
    debug_output:'getset_descriptor'
    debug_output_type:'getset_descriptor'
    imprint:'getset_descriptor'
    imprint_connection:'getset_descriptor'
    imprint_data:'getset_descriptor'
    merge_tolerance:'getset_descriptor'
    merge_tolerance_type:'getset_descriptor'
    output_type:'getset_descriptor'
    pass_cell_data:'getset_descriptor'
    pass_point_data:'getset_descriptor'
    point_interpolation:'getset_descriptor'
    target:'getset_descriptor'
    target_connection:'getset_descriptor'
    target_data:'getset_descriptor'
    tolerance:'getset_descriptor'
    tolerance_strategy:'getset_descriptor'
    triangulate_output:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def BoundaryEdgeInsertionOff(self) -> None: ...
    def BoundaryEdgeInsertionOn(self) -> None: ...
    def GetBoundaryEdgeInsertion(self) -> bool: ...
    def GetDebugCellId(self) -> int: ...
    def GetDebugOutput(self) -> 'vtkPolyData': ...
    def GetDebugOutputType(self) -> int: ...
    def GetDebugOutputTypeMaxValue(self) -> int: ...
    def GetDebugOutputTypeMinValue(self) -> int: ...
    def GetImprint(self) -> 'vtkDataObject': ...
    def GetImprintConnection(self) -> 'vtkAlgorithmOutput': ...
    def GetMergeTolerance(self) -> float: ...
    def GetMergeToleranceMaxValue(self) -> float: ...
    def GetMergeToleranceMinValue(self) -> float: ...
    def GetMergeToleranceType(self) -> int: ...
    def GetMergeToleranceTypeMaxValue(self) -> int: ...
    def GetMergeToleranceTypeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputType(self) -> int: ...
    def GetOutputTypeMaxValue(self) -> int: ...
    def GetOutputTypeMinValue(self) -> int: ...
    def GetPassCellData(self) -> bool: ...
    def GetPassPointData(self) -> bool: ...
    def GetPointInterpolation(self) -> int: ...
    def GetPointInterpolationMaxValue(self) -> int: ...
    def GetPointInterpolationMinValue(self) -> int: ...
    def GetTarget(self) -> 'vtkDataObject': ...
    def GetTargetConnection(self) -> 'vtkAlgorithmOutput': ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def GetToleranceStrategy(self) -> int: ...
    def GetToleranceStrategyMaxValue(self) -> int: ...
    def GetToleranceStrategyMinValue(self) -> int: ...
    def GetTriangulateOutput(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkImprintFilter': ...
    def PassCellDataOff(self) -> None: ...
    def PassCellDataOn(self) -> None: ...
    def PassPointDataOff(self) -> None: ...
    def PassPointDataOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkImprintFilter': ...
    def SetBoundaryEdgeInsertion(self, _arg:bool) -> None: ...
    def SetDebugCellId(self, _arg:int) -> None: ...
    def SetDebugOutputType(self, _arg:int) -> None: ...
    def SetDebugOutputTypeToNoDebugOutput(self) -> None: ...
    def SetDebugOutputTypeToTriangulationInput(self) -> None: ...
    def SetDebugOutputTypeToTriangulationOutput(self) -> None: ...
    def SetImprintConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetImprintData(self, imprint:'vtkDataObject') -> None: ...
    def SetMergeTolerance(self, _arg:float) -> None: ...
    def SetMergeToleranceType(self, _arg:int) -> None: ...
    def SetMergeToleranceTypeToAbsolute(self) -> None: ...
    def SetMergeToleranceTypeToAverageEdge(self) -> None: ...
    def SetMergeToleranceTypeToMinEdge(self) -> None: ...
    def SetMergeToleranceTypeToRelativeToProjection(self) -> None: ...
    def SetOutputType(self, _arg:int) -> None: ...
    def SetOutputTypeToImprintedCells(self) -> None: ...
    def SetOutputTypeToImprintedRegion(self) -> None: ...
    def SetOutputTypeToMergedImprint(self) -> None: ...
    def SetOutputTypeToProjectedImprint(self) -> None: ...
    def SetOutputTypeToTargetCells(self) -> None: ...
    def SetPassCellData(self, _arg:bool) -> None: ...
    def SetPassPointData(self, _arg:bool) -> None: ...
    def SetPointInterpolation(self, _arg:int) -> None: ...
    def SetPointInterpolationToImprintEdges(self) -> None: ...
    def SetPointInterpolationToTargetEdges(self) -> None: ...
    def SetTargetConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetTargetData(self, target:'vtkDataObject') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...
    def SetToleranceStrategy(self, _arg:int) -> None: ...
    def SetToleranceStrategyToDecoupled(self) -> None: ...
    def SetToleranceStrategyToLinked(self) -> None: ...
    def SetTriangulateOutput(self, _arg:bool) -> None: ...
    def TriangulateOutputOff(self) -> None: ...
    def TriangulateOutputOn(self) -> None: ...

class vtkLinearCellExtrusionFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    locator:'getset_descriptor'
    merge_duplicate_points:'getset_descriptor'
    scale_factor:'getset_descriptor'
    use_user_vector:'getset_descriptor'
    user_vector:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CreateDefaultLocator(self) -> None: ...
    def GetLocator(self) -> 'vtkIncrementalPointLocator': ...
    def GetMergeDuplicatePoints(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def GetUseUserVector(self) -> bool: ...
    def GetUserVector(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MergeDuplicatePointsOff(self) -> None: ...
    def MergeDuplicatePointsOn(self) -> None: ...
    def NewInstance(self) -> 'vtkLinearCellExtrusionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLinearCellExtrusionFilter': ...
    def SetLocator(self, _arg:'vtkIncrementalPointLocator') -> None: ...
    def SetMergeDuplicatePoints(self, _arg:bool) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    def SetUseUserVector(self, _arg:bool) -> None: ...
    @overload
    def SetUserVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetUserVector(self, _arg:Sequence[float]) -> None: ...
    def UseUserVectorOff(self) -> None: ...
    def UseUserVectorOn(self) -> None: ...

class vtkLinearExtrusionFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    capping:'getset_descriptor'
    extrusion_point:'getset_descriptor'
    extrusion_type:'getset_descriptor'
    scale_factor:'getset_descriptor'
    vector:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def GetCapping(self) -> int: ...
    def GetExtrusionPoint(self) -> Tuple[float, float, float]: ...
    def GetExtrusionType(self) -> int: ...
    def GetExtrusionTypeMaxValue(self) -> int: ...
    def GetExtrusionTypeMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetScaleFactor(self) -> float: ...
    def GetVector(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLinearExtrusionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLinearExtrusionFilter': ...
    def SetCapping(self, _arg:int) -> None: ...
    @overload
    def SetExtrusionPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetExtrusionPoint(self, _arg:Sequence[float]) -> None: ...
    def SetExtrusionType(self, _arg:int) -> None: ...
    def SetExtrusionTypeToNormalExtrusion(self) -> None: ...
    def SetExtrusionTypeToPointExtrusion(self) -> None: ...
    def SetExtrusionTypeToVectorExtrusion(self) -> None: ...
    def SetScaleFactor(self, _arg:float) -> None: ...
    @overload
    def SetVector(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetVector(self, _arg:Sequence[float]) -> None: ...

class vtkLinearSubdivisionFilter(vtkmodules.vtkFiltersGeneral.vtkInterpolatingSubdivisionFilter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLinearSubdivisionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLinearSubdivisionFilter': ...

class vtkLoopSubdivisionFilter(vtkmodules.vtkFiltersGeneral.vtkApproximatingSubdivisionFilter):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkLoopSubdivisionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkLoopSubdivisionFilter': ...

class vtkOutlineFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class CompositeOutlineStyle(int): ...
    LEAF_DATASETS:'CompositeOutlineStyle'
    ROOT_AND_LEAFS:'CompositeOutlineStyle'
    ROOT_LEVEL:'CompositeOutlineStyle'
    SPECIFIED_INDEX:'CompositeOutlineStyle'
    composite_style:'getset_descriptor'
    generate_faces:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddIndex(self, index:int) -> None: ...
    def GenerateFacesOff(self) -> None: ...
    def GenerateFacesOn(self) -> None: ...
    def GetCompositeStyle(self) -> int: ...
    def GetGenerateFaces(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkOutlineFilter': ...
    def RemoveAllIndices(self) -> None: ...
    def RemoveIndex(self, index:int) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkOutlineFilter': ...
    def SetCompositeStyle(self, _arg:int) -> None: ...
    def SetCompositeStyleToLeafs(self) -> None: ...
    def SetCompositeStyleToRoot(self) -> None: ...
    def SetCompositeStyleToRootAndLeafs(self) -> None: ...
    def SetCompositeStyleToSpecifiedIndex(self) -> None: ...
    def SetGenerateFaces(self, _arg:int) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...

class vtkPolyDataPointSampler(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    RANDOM_GENERATION:int
    REGULAR_GENERATION:int
    distance:'getset_descriptor'
    generate_edge_points:'getset_descriptor'
    generate_interior_points:'getset_descriptor'
    generate_vertex_points:'getset_descriptor'
    generate_vertices:'getset_descriptor'
    interpolate_point_data:'getset_descriptor'
    point_generation_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateEdgePointsOff(self) -> None: ...
    def GenerateEdgePointsOn(self) -> None: ...
    def GenerateInteriorPointsOff(self) -> None: ...
    def GenerateInteriorPointsOn(self) -> None: ...
    def GenerateVertexPointsOff(self) -> None: ...
    def GenerateVertexPointsOn(self) -> None: ...
    def GenerateVerticesOff(self) -> None: ...
    def GenerateVerticesOn(self) -> None: ...
    def GetDistance(self) -> float: ...
    def GetDistanceMaxValue(self) -> float: ...
    def GetDistanceMinValue(self) -> float: ...
    def GetGenerateEdgePoints(self) -> bool: ...
    def GetGenerateInteriorPoints(self) -> bool: ...
    def GetGenerateVertexPoints(self) -> bool: ...
    def GetGenerateVertices(self) -> bool: ...
    def GetInterpolatePointData(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPointGenerationMode(self) -> int: ...
    def GetPointGenerationModeMaxValue(self) -> int: ...
    def GetPointGenerationModeMinValue(self) -> int: ...
    def InterpolatePointDataOff(self) -> None: ...
    def InterpolatePointDataOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkPolyDataPointSampler': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkPolyDataPointSampler': ...
    def SetDistance(self, _arg:float) -> None: ...
    def SetGenerateEdgePoints(self, _arg:bool) -> None: ...
    def SetGenerateInteriorPoints(self, _arg:bool) -> None: ...
    def SetGenerateVertexPoints(self, _arg:bool) -> None: ...
    def SetGenerateVertices(self, _arg:bool) -> None: ...
    def SetInterpolatePointData(self, _arg:bool) -> None: ...
    def SetPointGenerationMode(self, _arg:int) -> None: ...
    def SetPointGenerationModeToRandom(self) -> None: ...
    def SetPointGenerationModeToRegular(self) -> None: ...

class vtkProjectedTexture(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    aspect_ratio:'getset_descriptor'
    camera_mode:'getset_descriptor'
    focal_point:'getset_descriptor'
    mirror_separation:'getset_descriptor'
    orientation:'getset_descriptor'
    position:'getset_descriptor'
    s_range:'getset_descriptor'
    t_range:'getset_descriptor'
    up:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAspectRatio(self) -> Tuple[float, float, float]: ...
    def GetCameraMode(self) -> int: ...
    def GetFocalPoint(self) -> Tuple[float, float, float]: ...
    def GetMirrorSeparation(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOrientation(self) -> Tuple[float, float, float]: ...
    def GetPosition(self) -> Tuple[float, float, float]: ...
    def GetSRange(self) -> Tuple[float, float]: ...
    def GetTRange(self) -> Tuple[float, float]: ...
    def GetUp(self) -> Tuple[float, float, float]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkProjectedTexture': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkProjectedTexture': ...
    @overload
    def SetAspectRatio(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAspectRatio(self, _arg:Sequence[float]) -> None: ...
    def SetCameraMode(self, _arg:int) -> None: ...
    def SetCameraModeToPinhole(self) -> None: ...
    def SetCameraModeToTwoMirror(self) -> None: ...
    @overload
    def SetFocalPoint(self, focalPoint:MutableSequence[float]) -> None: ...
    @overload
    def SetFocalPoint(self, x:float, y:float, z:float) -> None: ...
    def SetMirrorSeparation(self, _arg:float) -> None: ...
    @overload
    def SetPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPosition(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetSRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetSRange(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetTRange(self, _arg1:float, _arg2:float) -> None: ...
    @overload
    def SetTRange(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetUp(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetUp(self, _arg:Sequence[float]) -> None: ...

class vtkQuadRotationalExtrusionFilter(vtkmodules.vtkCommonExecutionModel.vtkMultiBlockDataSetAlgorithm):
    class RotationAxis(int): ...
    USE_X:'RotationAxis'
    USE_Y:'RotationAxis'
    USE_Z:'RotationAxis'
    axis:'getset_descriptor'
    capping:'getset_descriptor'
    default_angle:'getset_descriptor'
    delta_radius:'getset_descriptor'
    resolution:'getset_descriptor'
    translation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def AddPerBlockAngle(self, blockId:int, angle:float) -> None: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def GetAxis(self) -> int: ...
    def GetAxisMaxValue(self) -> int: ...
    def GetAxisMinValue(self) -> int: ...
    def GetCapping(self) -> int: ...
    def GetDefaultAngle(self) -> float: ...
    def GetDeltaRadius(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetTranslation(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkQuadRotationalExtrusionFilter': ...
    def RemoveAllPerBlockAngles(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkQuadRotationalExtrusionFilter': ...
    def SetAxis(self, _arg:int) -> None: ...
    def SetAxisToX(self) -> None: ...
    def SetAxisToY(self) -> None: ...
    def SetAxisToZ(self) -> None: ...
    def SetCapping(self, _arg:int) -> None: ...
    def SetDefaultAngle(self, _arg:float) -> None: ...
    def SetDeltaRadius(self, _arg:float) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def SetTranslation(self, _arg:float) -> None: ...

class vtkRibbonFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    angle:'getset_descriptor'
    default_normal:'getset_descriptor'
    generate_t_coords:'getset_descriptor'
    texture_length:'getset_descriptor'
    use_default_normal:'getset_descriptor'
    vary_width:'getset_descriptor'
    width:'getset_descriptor'
    width_factor:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAngle(self) -> float: ...
    def GetAngleMaxValue(self) -> float: ...
    def GetAngleMinValue(self) -> float: ...
    def GetDefaultNormal(self) -> Tuple[float, float, float]: ...
    def GetGenerateTCoords(self) -> int: ...
    def GetGenerateTCoordsAsString(self) -> str: ...
    def GetGenerateTCoordsMaxValue(self) -> int: ...
    def GetGenerateTCoordsMinValue(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextureLength(self) -> float: ...
    def GetTextureLengthMaxValue(self) -> float: ...
    def GetTextureLengthMinValue(self) -> float: ...
    def GetUseDefaultNormal(self) -> int: ...
    def GetVaryWidth(self) -> int: ...
    def GetWidth(self) -> float: ...
    def GetWidthFactor(self) -> float: ...
    def GetWidthMaxValue(self) -> float: ...
    def GetWidthMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRibbonFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRibbonFilter': ...
    def SetAngle(self, _arg:float) -> None: ...
    @overload
    def SetDefaultNormal(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetDefaultNormal(self, _arg:Sequence[float]) -> None: ...
    def SetGenerateTCoords(self, _arg:int) -> None: ...
    def SetGenerateTCoordsToNormalizedLength(self) -> None: ...
    def SetGenerateTCoordsToOff(self) -> None: ...
    def SetGenerateTCoordsToUseLength(self) -> None: ...
    def SetGenerateTCoordsToUseScalars(self) -> None: ...
    def SetTextureLength(self, _arg:float) -> None: ...
    def SetUseDefaultNormal(self, _arg:int) -> None: ...
    def SetVaryWidth(self, _arg:int) -> None: ...
    def SetWidth(self, _arg:float) -> None: ...
    def SetWidthFactor(self, _arg:float) -> None: ...
    def UseDefaultNormalOff(self) -> None: ...
    def UseDefaultNormalOn(self) -> None: ...
    def VaryWidthOff(self) -> None: ...
    def VaryWidthOn(self) -> None: ...

class vtkRotationalExtrusionFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    angle:'getset_descriptor'
    capping:'getset_descriptor'
    delta_radius:'getset_descriptor'
    resolution:'getset_descriptor'
    rotation_axis:'getset_descriptor'
    translation:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def GetAngle(self) -> float: ...
    def GetCapping(self) -> int: ...
    def GetDeltaRadius(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetRotationAxis(self) -> Tuple[float, float, float]: ...
    def GetTranslation(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRotationalExtrusionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRotationalExtrusionFilter': ...
    def SetAngle(self, _arg:float) -> None: ...
    def SetCapping(self, _arg:int) -> None: ...
    def SetDeltaRadius(self, _arg:float) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    @overload
    def SetRotationAxis(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetRotationAxis(self, _arg:Sequence[float]) -> None: ...
    def SetTranslation(self, _arg:float) -> None: ...

class vtkRuledSurfaceFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    close_surface:'getset_descriptor'
    distance_factor:'getset_descriptor'
    offset:'getset_descriptor'
    on_ratio:'getset_descriptor'
    orient_loops:'getset_descriptor'
    pass_lines:'getset_descriptor'
    resolution:'getset_descriptor'
    ruled_mode:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CloseSurfaceOff(self) -> None: ...
    def CloseSurfaceOn(self) -> None: ...
    def GetCloseSurface(self) -> int: ...
    def GetDistanceFactor(self) -> float: ...
    def GetDistanceFactorMaxValue(self) -> float: ...
    def GetDistanceFactorMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOffset(self) -> int: ...
    def GetOffsetMaxValue(self) -> int: ...
    def GetOffsetMinValue(self) -> int: ...
    def GetOnRatio(self) -> int: ...
    def GetOnRatioMaxValue(self) -> int: ...
    def GetOnRatioMinValue(self) -> int: ...
    def GetOrientLoops(self) -> int: ...
    def GetPassLines(self) -> int: ...
    def GetResolution(self) -> Tuple[int, int]: ...
    def GetRuledMode(self) -> int: ...
    def GetRuledModeAsString(self) -> str: ...
    def GetRuledModeMaxValue(self) -> int: ...
    def GetRuledModeMinValue(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRuledSurfaceFilter': ...
    def OrientLoopsOff(self) -> None: ...
    def OrientLoopsOn(self) -> None: ...
    def PassLinesOff(self) -> None: ...
    def PassLinesOn(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRuledSurfaceFilter': ...
    def SetCloseSurface(self, _arg:int) -> None: ...
    def SetDistanceFactor(self, _arg:float) -> None: ...
    def SetOffset(self, _arg:int) -> None: ...
    def SetOnRatio(self, _arg:int) -> None: ...
    def SetOrientLoops(self, _arg:int) -> None: ...
    def SetPassLines(self, _arg:int) -> None: ...
    @overload
    def SetResolution(self, _arg1:int, _arg2:int) -> None: ...
    @overload
    def SetResolution(self, _arg:Sequence[int]) -> None: ...
    def SetRuledMode(self, _arg:int) -> None: ...
    def SetRuledModeToPointWalk(self) -> None: ...
    def SetRuledModeToResample(self) -> None: ...

class vtkSectorSource(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    circumferential_resolution:'getset_descriptor'
    end_angle:'getset_descriptor'
    inner_radius:'getset_descriptor'
    outer_radius:'getset_descriptor'
    radial_resolution:'getset_descriptor'
    start_angle:'getset_descriptor'
    z_coord:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetCircumferentialResolution(self) -> int: ...
    def GetCircumferentialResolutionMaxValue(self) -> int: ...
    def GetCircumferentialResolutionMinValue(self) -> int: ...
    def GetEndAngle(self) -> float: ...
    def GetEndAngleMaxValue(self) -> float: ...
    def GetEndAngleMinValue(self) -> float: ...
    def GetInnerRadius(self) -> float: ...
    def GetInnerRadiusMaxValue(self) -> float: ...
    def GetInnerRadiusMinValue(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOuterRadius(self) -> float: ...
    def GetOuterRadiusMaxValue(self) -> float: ...
    def GetOuterRadiusMinValue(self) -> float: ...
    def GetRadialResolution(self) -> int: ...
    def GetRadialResolutionMaxValue(self) -> int: ...
    def GetRadialResolutionMinValue(self) -> int: ...
    def GetStartAngle(self) -> float: ...
    def GetStartAngleMaxValue(self) -> float: ...
    def GetStartAngleMinValue(self) -> float: ...
    def GetZCoord(self) -> float: ...
    def GetZCoordMaxValue(self) -> float: ...
    def GetZCoordMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSectorSource': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSectorSource': ...
    def SetCircumferentialResolution(self, _arg:int) -> None: ...
    def SetEndAngle(self, _arg:float) -> None: ...
    def SetInnerRadius(self, _arg:float) -> None: ...
    def SetOuterRadius(self, _arg:float) -> None: ...
    def SetRadialResolution(self, _arg:int) -> None: ...
    def SetStartAngle(self, _arg:float) -> None: ...
    def SetZCoord(self, _arg:float) -> None: ...

class vtkSelectEnclosedPoints(vtkmodules.vtkCommonExecutionModel.vtkDataSetAlgorithm):
    check_surface:'getset_descriptor'
    inside_out:'getset_descriptor'
    surface:'getset_descriptor'
    surface_connection:'getset_descriptor'
    surface_data:'getset_descriptor'
    tolerance:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CheckSurfaceOff(self) -> None: ...
    def CheckSurfaceOn(self) -> None: ...
    def Complete(self) -> None: ...
    def GetCheckSurface(self) -> int: ...
    def GetInsideOut(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetSurface(self) -> 'vtkPolyData': ...
    @overload
    def GetSurface(self, sourceInfo:'vtkInformationVector') -> 'vtkPolyData': ...
    def GetTolerance(self) -> float: ...
    def GetToleranceMaxValue(self) -> float: ...
    def GetToleranceMinValue(self) -> float: ...
    def Initialize(self, surface:'vtkPolyData') -> None: ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsInside(self, inputPtId:int) -> int: ...
    @overload
    def IsInsideSurface(self, x:MutableSequence[float]) -> int: ...
    @overload
    def IsInsideSurface(self, x:float, y:float, z:float) -> int: ...
    @overload
    @staticmethod
    def IsInsideSurface(x:MutableSequence[float], surface:'vtkPolyData', bds:MutableSequence[float], length:float, tol:float, locator:'vtkAbstractCellLocator', cellIds:'vtkIdList', genCell:'vtkGenericCell', counter:'vtkIntersectionCounter', poole:'vtkRandomPool'=..., seqIdx:int=0) -> int: ...
    @staticmethod
    def IsSurfaceClosed(surface:'vtkPolyData') -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSelectEnclosedPoints': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSelectEnclosedPoints': ...
    def SetCheckSurface(self, _arg:int) -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    def SetSurfaceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetSurfaceData(self, pd:'vtkPolyData') -> None: ...
    def SetTolerance(self, _arg:float) -> None: ...

class vtkSelectPolyData(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    closest_point:'getset_descriptor'
    edge_search_mode:'getset_descriptor'
    generate_selection_scalars:'getset_descriptor'
    generate_unselected_output:'getset_descriptor'
    inside_out:'getset_descriptor'
    loop:'getset_descriptor'
    m_time:'getset_descriptor'
    selection_edges:'getset_descriptor'
    selection_mode:'getset_descriptor'
    selection_scalars_array_name:'getset_descriptor'
    unselected_output:'getset_descriptor'
    unselected_output_port:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GenerateSelectionScalarsOff(self) -> None: ...
    def GenerateSelectionScalarsOn(self) -> None: ...
    def GenerateUnselectedOutputOff(self) -> None: ...
    def GenerateUnselectedOutputOn(self) -> None: ...
    def GetClosestPoint(self) -> Tuple[float, float, float]: ...
    def GetEdgeSearchMode(self) -> int: ...
    def GetEdgeSearchModeAsString(self) -> str: ...
    def GetEdgeSearchModeMaxValue(self) -> int: ...
    def GetEdgeSearchModeMinValue(self) -> int: ...
    def GetGenerateSelectionScalars(self) -> int: ...
    def GetGenerateUnselectedOutput(self) -> int: ...
    def GetInsideOut(self) -> int: ...
    def GetLoop(self) -> 'vtkPoints': ...
    def GetMTime(self) -> int: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelectionEdges(self) -> 'vtkPolyData': ...
    def GetSelectionMode(self) -> int: ...
    def GetSelectionModeAsString(self) -> str: ...
    def GetSelectionModeMaxValue(self) -> int: ...
    def GetSelectionModeMinValue(self) -> int: ...
    def GetSelectionScalarsArrayName(self) -> str: ...
    def GetUnselectedOutput(self) -> 'vtkPolyData': ...
    def GetUnselectedOutputPort(self) -> 'vtkAlgorithmOutput': ...
    def InsideOutOff(self) -> None: ...
    def InsideOutOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSelectPolyData': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSelectPolyData': ...
    @overload
    def SetClosestPoint(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetClosestPoint(self, _arg:Sequence[float]) -> None: ...
    def SetEdgeSearchMode(self, _arg:int) -> None: ...
    def SetEdgeSearchModeToDijkstra(self) -> None: ...
    def SetEdgeSearchModeToGreedy(self) -> None: ...
    def SetGenerateSelectionScalars(self, _arg:int) -> None: ...
    def SetGenerateUnselectedOutput(self, _arg:int) -> None: ...
    def SetInsideOut(self, _arg:int) -> None: ...
    def SetLoop(self, __a:'vtkPoints') -> None: ...
    def SetSelectionMode(self, _arg:int) -> None: ...
    def SetSelectionModeToClosestPointRegion(self) -> None: ...
    def SetSelectionModeToLargestRegion(self) -> None: ...
    def SetSelectionModeToSmallestRegion(self) -> None: ...
    def SetSelectionScalarsArrayName(self, _arg:str) -> None: ...

class vtkSpherePuzzle(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    state:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetState(self) -> Pointer: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MoveHorizontal(self, section:int, percentage:int, rightFlag:int) -> None: ...
    def MovePoint(self, percentage:int) -> None: ...
    def MoveVertical(self, section:int, percentage:int, rightFlag:int) -> None: ...
    def NewInstance(self) -> 'vtkSpherePuzzle': ...
    def Reset(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSpherePuzzle': ...
    def SetPoint(self, x:float, y:float, z:float) -> int: ...

class vtkSpherePuzzleArrows(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    permutation:'getset_descriptor'
    permutation_component:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPermutation(self) -> Tuple[int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int, int]: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSpherePuzzleArrows': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSpherePuzzleArrows': ...
    @overload
    def SetPermutation(self, data:Sequence[int]) -> None: ...
    @overload
    def SetPermutation(self, puz:'vtkSpherePuzzle') -> None: ...
    def SetPermutationComponent(self, comp:int, val:int) -> None: ...

class vtkSubdivideTetra(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    def __init__(self, **properties:Any) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkSubdivideTetra': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkSubdivideTetra': ...

class vtkTrimmedExtrusionFilter(vtkmodules.vtkCommonExecutionModel.vtkPolyDataAlgorithm):
    class ExtrusionStrategy(int): ...
    class CappingStrategy(int): ...
    ALL_EDGES:'ExtrusionStrategy'
    AVERAGE_DISTANCE:'CappingStrategy'
    BOUNDARY_EDGES:'ExtrusionStrategy'
    INTERSECTION:'CappingStrategy'
    MAXIMUM_DISTANCE:'CappingStrategy'
    MINIMUM_DISTANCE:'CappingStrategy'
    capping:'getset_descriptor'
    capping_strategy:'getset_descriptor'
    extrusion_direction:'getset_descriptor'
    extrusion_strategy:'getset_descriptor'
    locator:'getset_descriptor'
    trim_surface:'getset_descriptor'
    trim_surface_connection:'getset_descriptor'
    trim_surface_data:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def CappingOff(self) -> None: ...
    def CappingOn(self) -> None: ...
    def GetCapping(self) -> int: ...
    def GetCappingStrategy(self) -> int: ...
    def GetExtrusionDirection(self) -> Tuple[float, float, float]: ...
    def GetExtrusionStrategy(self) -> int: ...
    def GetLocator(self) -> 'vtkAbstractCellLocator': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    @overload
    def GetTrimSurface(self) -> 'vtkPolyData': ...
    @overload
    def GetTrimSurface(self, sourceInfo:'vtkInformationVector') -> 'vtkPolyData': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkTrimmedExtrusionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkTrimmedExtrusionFilter': ...
    def SetCapping(self, _arg:int) -> None: ...
    def SetCappingStrategy(self, _arg:int) -> None: ...
    def SetCappingStrategyToAverageDistance(self) -> None: ...
    def SetCappingStrategyToIntersection(self) -> None: ...
    def SetCappingStrategyToMaximumDistance(self) -> None: ...
    def SetCappingStrategyToMinimumDistance(self) -> None: ...
    @overload
    def SetExtrusionDirection(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetExtrusionDirection(self, _arg:Sequence[float]) -> None: ...
    def SetExtrusionStrategy(self, _arg:int) -> None: ...
    def SetExtrusionStrategyToAllEdges(self) -> None: ...
    def SetExtrusionStrategyToBoundaryEdges(self) -> None: ...
    def SetLocator(self, locator:'vtkAbstractCellLocator') -> None: ...
    def SetTrimSurfaceConnection(self, algOutput:'vtkAlgorithmOutput') -> None: ...
    def SetTrimSurfaceData(self, pd:'vtkPolyData') -> None: ...

class vtkVolumeOfRevolutionFilter(vtkmodules.vtkCommonExecutionModel.vtkUnstructuredGridAlgorithm):
    axis_direction:'getset_descriptor'
    axis_position:'getset_descriptor'
    output_points_precision:'getset_descriptor'
    resolution:'getset_descriptor'
    sweep_angle:'getset_descriptor'
    def __init__(self, **properties:Any) -> None: ...
    def GetAxisDirection(self) -> Tuple[float, float, float]: ...
    def GetAxisPosition(self) -> Tuple[float, float, float]: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutputPointsPrecision(self) -> int: ...
    def GetOutputPointsPrecisionMaxValue(self) -> int: ...
    def GetOutputPointsPrecisionMinValue(self) -> int: ...
    def GetResolution(self) -> int: ...
    def GetResolutionMaxValue(self) -> int: ...
    def GetResolutionMinValue(self) -> int: ...
    def GetSweepAngle(self) -> float: ...
    def GetSweepAngleMaxValue(self) -> float: ...
    def GetSweepAngleMinValue(self) -> float: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkVolumeOfRevolutionFilter': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkVolumeOfRevolutionFilter': ...
    @overload
    def SetAxisDirection(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisDirection(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetAxisPosition(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetAxisPosition(self, _arg:Sequence[float]) -> None: ...
    def SetOutputPointsPrecision(self, _arg:int) -> None: ...
    def SetResolution(self, _arg:int) -> None: ...
    def SetSweepAngle(self, _arg:float) -> None: ...

